<?php

##################################################
#
# Copyright (c) 2004-2016 OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# GPL: http://www.gnu.org/licenses/gpl.txt
#
##################################################

/**
 * @subpackage Upgrade
 * @package Installation
 */

/**
 * This is the class remove_oldtables
 */
class remove_oldtables extends upgradescript {
//	protected $from_version = '0.0.0';  // version number lower than first released version, 2.0.0  //FIXME this is NEVER run!
//	protected $to_version = '2.2.1';  // old school modules were removed in 2.2.0

	/**
	 * name/title of upgrade script
	 * @return string
	 */
	static function name() { return "Remove deprecated tables"; }

	/**
	 * generic description of upgrade script
	 * @return string
	 */
	function description() { return "Prior to v2.2.0, old school modules used different tables.  This script removes existing tables."; }

	/**
	 * additional test(s) to see if upgrade script should be run
	 * @return bool
	 */
	function needed() {
        global $db;

        foreach (self::get_tables_list() as $table) {
            if ($db->tableExists($table)) {
                return true;
            }
        }
        return false;
	}

	/**
	 * converts the faq & filedownload tables to the new naming scheme
	 * @return bool
	 */
	function upgrade() {
	    global $db;

        $tables_dropped = 0;
        foreach (self::get_tables_list() as $table) {
            if ($db->tableExists($table)) {
                $db->dropTable($table);
            }
        }
        return ($tables_dropped?$tables_dropped:gt('No'))." ".gt('Deprecated tables removed.');
	}

    function get_tables_list() {
        return array(
            'faqs',
            'filedownloads',
            'headline',
            'user_subscriptions',
            'expeAlerts_subscribers',
            'calendar',
            'calendar_reminder_address',
            'calendar_external',
            'calendarmodule_config',
            'formbuilder_address',
            'formbuilder_control',
            'formbuilder_form',
            'formbuilder_report',
            'section_template',
            'poll_question',
            'poll_answer',
            'poll_timeblock',
            'simplepollmodule_config',
        );
    }
}

?>
