<?php

##################################################
#
# Copyright (c) 2004-2016 OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# GPL: http://www.gnu.org/licenses/gpl.txt
#
##################################################

/**
 * @subpackage Upgrade
 * @package Installation
 */

/**
 * This is the class remove_oldfiles
 */
class remove_oldfiles extends upgradescript {
	protected $from_version = '0.0.0';
//	protected $to_version = '2.0.9';
    public $priority = 90; // set this to a very low priority, since some scripts run based on existing files

	/**
	 * name/title of upgrade script
	 * @return string
	 */
	static function name() { return "Remove old files"; }

	/**
	 * generic description of upgrade script
	 * @return string
	 */
	function description() { return "Several system files have been moved or are no longer needed.  This Script removes those leftover files from previous versions."; }

    /**
   	 * This routine should perform additional test(s) to see if upgrade script should be run (files/tables exist, etc...)
   	 * @return bool
   	 */
   	function needed() {
   		return true;  // subclasses MUST return true to be run
   	}

	/**
	 * removes old files from a previous installation that now in a new location
	 * @return bool
	 */
	function upgrade() {

        $oldfiles = array (
            // trigger to allow installation, security risk if remains in system
            'install/not_configured',

            // misc old files
            'captcha.php',
            'captcha_why.php',
            'compat.php',
            'content_selector.php',
            'core_podcast.php',
            'core_rss.php',
            'db_recover.php',
            'deps.php',
            'edit_page.php',
            'exponent_compat.php',
            'exponent_setup.php',
            'exponent_variables.php',
            'exponent_version.php.orig',
            'iconspopup.php',
            'login_redirect.php',
            'manifest.php',
            'mod_preview.php',
            'module_preview.php',
            'orphan_content_selector.php',
            'orphan_source_selector.php',
            'package.xml',
            'phpdoc.ini',
            'podcast.php',
            'popup.php',
            'send_reminders.php',
            'site_podcast.php',
            'rss.php',
            'Makefile',
            'ABOUT',
            'CHANGELOG',
            'CREDITS',
            'INSTALLATION',
            'README',
            'RELEASE',
            'TODO',
            'readme-reminders.txt',
            // 3rd party library updates
            'external/adminer/adminer-3.6.1.php',
            'external/adminer/adminer-3.6.1-mysql.php',
            'external/adminer/adminer-3.6.1-mysql-en.php',
            'external/adminer/adminer-3.6.3-mysql-en.php',
			'external/adminer/adminer-3.6.3-mysql.php',
            'external/adminer/adminer-3.6.4-mysql-en.php',
			'external/adminer/adminer-3.6.4-mysql.php',
            'external/adminer/adminer-3.7.0-mysql-en.php',
            'external/adminer/adminer-3.7.1-mysql.php',
            'external/adminer/adminer-4.1.0-mysql.php',
            'external/adminer/adminer-4.2.0-mysql.php',
            'external/adminer/adminer-4.2.1-mysql.php',
			'external/adminer/adminer-4.2.2-mysql.php',
			'external/adminer/adminer-4.2.3-mysql.php',
			'external/adminer/adminer-4.2.4-mysql.php',
            'external/editors/_header.tpl',
            'external/editors/Default.tpl',
            'external/editors/FCKeditor.tpl',
            'external/editors/fcktoolbarconfig.js.php',
            'external/editors/fcktemplates.xml',
            'external/editors/fckstyles.xml',
            'external/editors/wysiwyg-styles.css',
            'external/editors/ckeditor/ckeditor_basic.js',
            'external/editors/ckeditor/ckeditor_basic_source.js',
            'external/editors/ckeditor/ckeditor_php5.php',
            'external/editors/ckeditor/ckeditor_source.js',
            'external/editors/connector/FCKeditor_link.php',
            'external/editors/connector/insert_image.php',
            'external/editors/connector/link.php',
            'external/editors/connector/popup.js',
            'external/editors/connector/section_linked.php',
//            'external/html5forms/modernizr-262.js',
			'external/iCalcreator.class.php',
            'external/jquery/js/jquery-1.8.3.js',
            'external/jquery/js/jquery-1.8.3.min.js',
            'external/jquery/js/jquery-1.9.0.js',
            'external/jquery/js/jquery-1.9.0.min.js',
            'external/jquery/js/jquery-1.9.1.js',
            'external/jquery/js/jquery-1.9.1.min.js',
            'external/jquery/js/jquery-1.10.0.js',
            'external/jquery/js/jquery-1.10.0.min.js',
            'external/jquery/js/jquery-1.10.1.js',
            'external/jquery/js/jquery-1.10.1.min.js',
            'external/jquery/js/jquery-1.10.2.js',
            'external/jquery/js/jquery-1.10.2.min.js',
            'external/jquery/js/jquery-1.11.0.min.js',
            'external/jquery/js/jquery-1.11.1.min.js',
            'external/jquery/js/jquery-1.11.2.min.js',
//			'external/jquery/js/jquery-1.11.3.min.js',  // now needed for old firefox browsers
			'external/jquery/js/jquery-1.12.0.min.js',
			'external/jquery/js/jquery-1.12.1.min.js',
			'external/jquery/js/jquery-1.12.2.min.js',
			'external/jquery/js/jquery-1.12.3.min.js',
            'external/jquery/js/jquery-2.1.0.min.js',
            'external/jquery/js/jquery-2.1.1.min.js',
            'external/jquery/js/jquery-2.1.3.min.js',
			'external/jquery/js/jquery-2.1.4.min.js',
			'external/jquery/js/jquery-2.2.0.min.js',
			'external/jquery/js/jquery-2.2.1.min.js',
			'external/jquery/js/jquery-2.2.2.min.js',
			'external/jquery/js/jquery-2.2.3.min.js',
            'external/jquery/js/jquery-migrate-1.1.0.js',
            'external/jquery/js/jquery-migrate-1.1.0.min.js',
            'external/jquery/js/jquery-migrate-1.1.1.js',
            'external/jquery/js/jquery-migrate-1.1.1.min.js',
            'external/jquery/js/jquery-migrate-1.2.1.js',
            'external/jquery/js/jquery-migrate-1.2.1.min.js',
            'external/jquery/js/jquery-ui-1.9.1.custom.js',
            'external/jquery/js/jquery-ui-1.9.1.custom.min.js',
            'external/jquery/js/jquery-ui-1.10.0.custom.js',
            'external/jquery/js/jquery-ui-1.10.0.custom.min.js',
            'external/jquery/js/jquery-ui-1.10.1.custom.js',
            'external/jquery/js/jquery-ui-1.10.1.custom.min.js',
            'external/jquery/js/jquery-ui-1.10.2.custom.js',
            'external/jquery/js/jquery-ui-1.10.2.custom.min.js',
			'external/jquery/js/jquery-ui.js',
			'external/jquery/addons/js/jquery.placeholder.js',
			'external/jquery/addons/js/spectrum.js',
			'external/jquery/addons/css/spectrum.css',
            'external/jquery/addons/js/pwstrength-bootstrap-1.1.2.js',
            'external/jquery/addons/js/pwstrength-bootstrap-1.1.5.js',
            'external/jquery/addons/js/pwstrength-bootstrap-1.2.0.js',
            'external/jquery/addons/js/pwstrength-bootstrap-1.2.1.js',
            'external/jquery/addons/js/pwstrength-bootstrap-1.2.2.js',
            'external/jquery/addons/js/pwstrength-bootstrap-1.2.3.js',
            'external/jquery/addons/js/pwstrength-bootstrap-1.2.5.js',
            'external/jquery/addons/js/pwstrength-bootstrap-1.2.6.js',
            'external/jquery/addons/js/pwstrength-bootstrap-1.2.7.js',
			'external/jquery/addons/js/pwstrength.js',
			'external/jquery/addons/js/pwstrength-bootstrap-1.2.9.js',
			'external/jquery/addons/js/pwstrength-bootstrap-1.2.10.js',
			'external/jquery/addons/js/pwstrength-bootstrap.js',
            'external/less.php/Cache.php',
            'external/less.php/Less.php',
            'external/less.php/Version.php',
            'external/lessphp/plessc',
//			'external/excanvas.js',
            'external/png-opacity.htc',
            'external/recaptchalib.php',
            'external/SimpleAjaxUploader.js',
            // obsolete misc files
            'framework/conf/extensions/ldap.defaults.php',
            'framework/conf/extensions/sef.defaults.php',
            'framework/core/assets/less/rerankpanel.less',
            'framework/modules/common/views/configure/module_title.tpl',
            'framework/modules/countdown/views/countdown/edit.tpl',
            'framework/modules/filedownloads/views/filedownload/showall_oneclickdownload.tpl',
            'framework/modules/navigation/views/navigation/add_section.tpl',
			'framework/modules/pixidou/download.php',
			'framework/modules/pixidou/upload.php',
            'framework/modules/text/views/text/showall_merge.tpl',
            'framework/modules/text/views/text/showall_tabview.tpl',
            'framework/plugins/function.get_distance.php',
            'framework/plugins/function.get_favorites.php',
            'framework/plugins/function.getfilename.php',
            'framework/plugins/function.popupdatetime.php',
            'framework/plugins/modifier.html_substr.php',
            'framework/plugins/postfilter.includemiscfiles.php',
            'themes/basetheme/sample.eql',
            'themes/basetheme/sample.tar.gz',
            'themes/bootstrap3theme/modules/navigation/views/navigation/showall_Bootstrap Top Nav.tpl',
            'themes/bootstrap3theme/less/bootstrapcontrols.less',
            'themes/bootstraptheme/less/bootstrapcontrols.less',
            'themes/coolwatertheme/sample.eql',
            'themes/coolwatertheme/sample.tar.gz',
            'themes/multioptiontheme/sample.eql',
            'themes/multioptiontheme/sample.tar.gz',
            'themes/retrotheme/sample.eql',
            'themes/retrotheme/sample.tar.gz',
            'themes/simpletheme/sample.eql',
            'themes/simpletheme/sample.tar.gz',
            'install/pop.css',
            'install/pages/admin_user.php',
            'install/pages/dbcheck.php',
            'install/pages/dbconfig.php',
            'install/pages/sanity.php',
            'install/pages/save_admin.php',
            'install/pages/setlang.php',
            'install/pages/upgrade.php',
            'install/pages/upgrade_version.php',
            'install/upgrades/install_tables.php',
            'install/upgrades/convert_db_trim.php',
            'install/upgrades/remove_exp1_faqmodule.php',
            'install/upgrades/remove_locationref.php',
            'install/upgrades/upgrade_attachableitem_tables.php',
            // obsolete definitions/models
            'framework/core/definitions/bots.php',
            'framework/core/definitions/locationref.php',
            'framework/core/definitions/toolbar_FCKeditor.php',
            'framework/core/definitions/calendar.php',
            'framework/core/definitions/calendar_external.php',
            'framework/core/definitions/calendar_reminder_address.php',
            'framework/core/definitions/calendarmodule_config.php',
            'framework/core/definitions/eventdate.php',
            'framework/modules/news/models/rssfeed.php',
            // moved definitions/models
            'framework/core/definitions/expFiles.php',
            'framework/core/definitions/content_expFiles.php',
            'framework/core/models/expFile.php',
            'framework/core/definitions/expRss.php',
            'framework/core/models/expRss.php',
            'framework/core/definitions/subscribers.php',
            'framework/core/models/subscribers.php',
            'framework/core/models/expTwitter.php',
//            'framework/modules/twitter/models/expTwitter.php',
            'framework/core/definitions/search_extension.php',
            'framework/core/definitions/search_queries.php',
            'framework/core/definitions/container.php',
            'framework/core/definitions/modstate.php',
            'framework/modules/container/controllers/container2Controller.php',
            'framework/modules/container/models/container2.php',
            'framework/modules/container/views/container/_nocontent.tpl',
            'framework/modules/container/views/container/_popup_info.tpl',
            // ecommerce definitions
            'framework/core/definitions/billingcalculator.php',
            'framework/core/definitions/billingmethods.php',
            'framework/core/definitions/billingtransactions.php',
            'framework/core/definitions/bing_product_types.php',
            'framework/core/definitions/bing_product_types_storeCategories.php',
            'framework/core/definitions/crosssellItem_product.php',
            'framework/core/definitions/discounts.php',
            'framework/core/definitions/eventregistration.php',
            'framework/core/definitions/eventregistration_registrants.php',
            'framework/core/definitions/external_addresses.php',
            'framework/core/definitions/google_product_types.php',
            'framework/core/definitions/google_product_types_storeCategories.php',
            'framework/core/definitions/groupdiscounts.php',
            'framework/core/definitions/model_aliases.php',
            'framework/core/definitions/model_aliases_tmp.php',
            'framework/core/definitions/nextag_product_types.php',
            'framework/core/definitions/nextag_product_types_storeCategories.php',
            'framework/core/definitions/option.php',
            'framework/core/definitions/option_master.php',
            'framework/core/definitions/optiongroup.php',
            'framework/core/definitions/optiongroup_master.php',
            'framework/core/definitions/order_discounts.php',
            'framework/core/definitions/order_payments.php',
            'framework/core/definitions/order_status.php',
            'framework/core/definitions/order_status_changes.php',
            'framework/core/definitions/order_status_messages.php',
            'framework/core/definitions/order_type.php',
            'framework/core/definitions/orderitems.php',
            'framework/core/definitions/orders.php',
            'framework/core/definitions/orders_next_invoice_id.php',
            'framework/core/definitions/pricegrabber_product_types.php',
            'framework/core/definitions/pricegrabber_product_types_storeCategories.php',
            'framework/core/definitions/product.php',
            'framework/core/definitions/product_notes.php',
            'framework/core/definitions/product_status.php',
            'framework/core/definitions/product_storeCategories.php',
            'framework/core/definitions/promocodes.php',
            'framework/core/definitions/purchase_order.php',
            'framework/core/definitions/sales_reps.php',
            'framework/core/definitions/shippingcalculator.php',
            'framework/core/definitions/shippingmethods.php',
            'framework/core/definitions/shippingspeeds.php',
            'framework/core/definitions/shopping_product_types.php',
            'framework/core/definitions/shopping_product_types_storeCategories.php',
            'framework/core/definitions/shopzilla_product_types.php',
            'framework/core/definitions/shopzilla_product_types_storeCategories.php',
            'framework/core/definitions/storeCategories.php',
            'framework/core/definitions/tax_class.php',
            'framework/core/definitions/tax_geo.php',
            'framework/core/definitions/tax_rate.php',
            'framework/core/definitions/tax_zone.php',
            'framework/core/definitions/vendor.php',
            // ecommerce models
            'framework/core/models/billing.php',
            'framework/core/models/billingcalculator.php',
            'framework/core/models/billingmethod.php',
            'framework/core/models/billingtransaction.php',
            'framework/core/models/bing_product_types.php',
            'framework/core/models/childProduct.php',
            'framework/core/models/crosssellItem.php',
            'framework/core/models/discounts.php',
            'framework/core/models/ecomconfig.php',
            'framework/core/models/external_address.php',
            'framework/core/models/google_product_types.php',
            'framework/core/models/groupdiscounts.php',
            'framework/core/models/model_alias.php',
            'framework/core/models/nextag_product_types.php',
            'framework/core/models/option.php',
            'framework/core/models/option_master.php',
            'framework/core/models/optiongroup.php',
            'framework/core/models/optiongroup_master.php',
            'framework/core/models/order.php',
            'framework/core/models/order_discounts.php',
            'framework/core/models/order_status.php',
            'framework/core/models/order_status_changes.php',
            'framework/core/models/order_status_messages.php',
            'framework/core/models/order_type.php',
            'framework/core/models/orderitem.php',
            'framework/core/models/pricegrabber_product_types.php',
            'framework/core/models/product_notes.php',
            'framework/core/models/product_status.php',
            'framework/core/models/product_type.php',
            'framework/core/models/promocodes.php',
            'framework/core/models/purchase_order.php',
            'framework/core/models/sales_rep.php',
            'framework/core/models/shipping.php',
            'framework/core/models/shippingcalculator.php',
            'framework/core/models/shippingmethod.php',
            'framework/core/models/shippingspeeds.php',
            'framework/core/models/shopping_product_types.php',
            'framework/core/models/shopzilla_product_types.php',
            'framework/core/models/storeCategory.php',
            'framework/core/models/storeCategoryFeeds.php',
            'framework/core/models/taxclass.php',
            'framework/core/models/vendor.php',
            'framework/modules/ecommerce/models/childProduct.php',
            'framework/modules/ecommerce/definitions/external_addresses.php',
            'framework/modules/ecommerce/models/external_address.php',
             // ecommerce renamed views
            'framework/modules/administration/menus/upcomingevents.php',
            'framework/modules/administration/menus/user.php',
            'framework/modules/administration/menus/z-navigation.php',
            'framework/modules/ecommerce/views/store/showall_featured_products.tpl',
            'framework/modules/ecommerce/views/store/events_calendar.tpl',
            'framework/modules/ecommerce/views/store/search_by_model_old.tpl',
            'framework/modules/ecommerce/views/store/showall_category_featured_products.tpl',
            'framework/modules/ecommerce/views/store/upcoming_events.tpl',
            // core controllers/models/definitions moved to /framework/modules folder
            'framework/core/controllers/expCatController.php',
            'framework/core/controllers/expCommentController.php',
            'framework/core/controllers/expDefinableFieldController.php',
            'framework/core/controllers/expHTMLEditorController.php',
            'framework/core/controllers/expModuleController.php',
            'framework/core/controllers/expSimpleNoteController.php',
            'framework/core/controllers/expRatingController.php',
            'framework/core/controllers/expTagController.php',
            'framework/core/definitions/content_expCats.php',
            'framework/core/definitions/content_expComments.php',
            'framework/core/definitions/content_expDefinableFields.php',
            'framework/core/definitions/content_expDefinableFields_value.php',
            'framework/core/definitions/content_expSimpleNote.php',
            'framework/core/definitions/content_expRatings.php',
            'framework/core/definitions/content_expTags.php',
            'framework/core/definitions/expCats.php',
            'framework/core/definitions/expComments.php',
            'framework/core/definitions/expDefinableFields.php',
            'framework/core/definitions/expSimpleNote.php',
            'framework/core/definitions/expRatings.php',
            'framework/core/definitions/expTags.php',
            'framework/core/definitions/htmleditor_ckeditor.php',
            'framework/core/models/expCat.php',
            'framework/core/models/expComment.php',
            'framework/core/models/expDefinableField.php',
            'framework/core/models/expSimpleNote.php',
            'framework/core/models/expRating.php',
            'framework/core/models/expTag.php',
            // obsolete scripts
            'framework/core/assets/js/exp-attachableitems.js',
            'framework/core/assets/js/exp-ecomm.js',
            'framework/core/assets/js/exp-filepicker.js',
            'framework/core/assets/js/exp-layout.js',
            'framework/core/assets/js/exp-slideshow.js',
            'framework/core/assets/js/exp-upload.js',
            'framework/modules/ecommerce/assets/js/expand_panels.js',
            'framework/modules/ecommerce/assets/js/swatch.js',
            'framework/modules/file/assets/js/filemanager.js',
            'framework/modules/navigation/assets/js/yui-nav-js.js',
            'framework/modules/photoalbum/assets/js/slideshow.js',
            // obsolete widgets
            'framework/core/forms/controls/antispamcontrol.php',
            'framework/core/forms/controls/configcontrol.php',
            'framework/core/forms/controls/contactcontrol.php',
            'framework/core/forms/controls/listcontrol.php',
            'framework/core/forms/controls/massmailcontrol.php',
            'framework/core/forms/controls/nextbackcontrol.php',
            'framework/core/forms/controls/quantitycontrol.php',
            'framework/core/forms/controls/yuieditorcontrol.php',
            'framework/plugins/function.configpanel.php',
            'framework/plugins/function.yuilogger.php',
            'framework/plugins/bootstrap/function.bootstrap_navbar.php',
            'framework/plugins/bootstrap3/function.bootstrap_navbar.php',
            'framework/plugins/newui/function.bootstrap_navbar.php',
            'framework/plugins/newui/function.control.php',
            'framework/core/forms/controls/bootstrap3/texteditorcontrol.php',
            'framework/core/forms/controls/newui/autocompletecontrol.php',
            'framework/core/forms/controls/newui/calendarcontrol.php',
            'framework/core/forms/controls/newui/ckeditorcontrol.php',
            'framework/core/forms/controls/newui/colorcontrol.php',
            'framework/core/forms/controls/newui/countrycontrol.php',
            'framework/core/forms/controls/newui/countryregioncontrol.php',
            'framework/core/forms/controls/newui/customcontrol.php',
            'framework/core/forms/controls/newui/datetimecontrol.js',
            'framework/core/forms/controls/newui/emailcontrol.php',
            'framework/core/forms/controls/newui/hiddenfieldcontrol.php',
            'framework/core/forms/controls/newui/htmlcontrol.php',
            'framework/core/forms/controls/newui/htmleditorcontrol.php',
            'framework/core/forms/controls/newui/listbuildercontrol.js',
            'framework/core/forms/controls/newui/listbuildercontrol.php',
            'framework/core/forms/controls/newui/monthyearcontrol.php',
            'framework/core/forms/controls/newui/numbercontrol.php',
            'framework/core/forms/controls/newui/pagecontrol.php',
            'framework/core/forms/controls/newui/passwordcontrol.php',
            'framework/core/forms/controls/newui/popupdatetimecontrol.php',
            'framework/core/forms/controls/newui/rangecontrol.php',
            'framework/core/forms/controls/newui/statescontrol.php',
            'framework/core/forms/controls/newui/tagpickercontrol.php',
            'framework/core/forms/controls/newui/telcontrol.php',
            'framework/core/forms/controls/newui/textcontrol.php',
            'framework/core/forms/controls/newui/texteditorcontrol.php',
            'framework/core/forms/controls/newui/uploadcontrol.php',
            'framework/core/forms/controls/newui/urlcontrol.php',
            'framework/core/forms/controls/newui/yuicalendarcontrol.php',
            'framework/core/forms/controls/newui/yuidatetimecontrol.php',
            'framework/core/forms/controls/newui/yuieditorcontrol.php',
            // other obsolete files
            'framework/modules/twitter/assets/images/rt.png',
            'framework/modules/twitter/assets/images/tweeted.png',
            'framework/modules/file/connector/cwd.js',
            'framework/modules/file/connector/elFinder.js',
			// other obsolete & mis-placed views
			'framework/core/views/popup_general.tpl',
			'framework/core/views/popup_printerfriendly.tpl',
			'framework/modules/blog/views/blog/showall_test.tpl',
			'framework/modules/news/views/news/show_Expired.tpl',
			'framework/modules/news/views/news/showall_summary.tpl',
			'framework/modules/text/views/showall_inline.tpl',
			'framework/modules/text/views/showall_inline.bootstrap.tpl',
			'framework/modules/text/views/showall_inline.bootstrap3.tpl',
			'framework/modules/twitter/views/showall.tpl',
			'framework/modules/users/views/users/import_users.tpl',
			'framework/modules/users/views/users/confirm_password_email.tpl',
			'framework/modules/users/views/users/password_reset_email.tpl',
        );
		// check if the old file exists and remove it
        $files_removed = 0;
        foreach ($oldfiles as $file) {
            if (file_exists(BASE.$file)) {
                if (unlink(BASE.$file)) $files_removed++;
            }
        }
        // delete old directories
        $olddirs = array(
            'framework/subsystems/',
//            'framework/core/compat/',
            'framework/core/database/',
            'framework/core/datatypes/',
            'framework/core/datatypes/',
            'framework/core/forms/controls/newui/assets',
            'framework/core/js/',
            'framework/core/subsystems-1/',
            'framework/core/subsystems/forms/',
			'framework/core/view/',
            'framework/datatypes/',
            'framework/views/',
            'framework/modules-1/',
            'framework/modules/container/views/container2/',
            'framework/modules/countdown/assets/js/',
            'framework/modules/photoalbum/views/photos/',
            'framework/modules/expEvent/',
            'framework/modules/headline/',
            'framework/modules/flowplayer/',
            'framework/modules/youtube/',
            'plugins/',
            'modules/',
            'js/',
            'forms/',
            'extensionuploads/',
            'datatypes/',
            'compat/',
            'views/',
            'subsystems/',
            'conf/',
            'install/sitetypes/',
            'themes/common/',
            'themes/bootstraptheme/controls/',
            'themes/bootstraptheme/plugins/',
			'files/.quarantine',
			'files/.tmb',
			'tmp/ai-cache/',
			'tmp/graph-cache/',
            'tmp/js/',
            'tmp/mail/',
            'tmp/pods/',
			'tmp/thumbs/',
			'tmp/tmp/',
			'tmp/twitter/',
            'external/bootstrap/font/',
            'external/ckeditor/',
            'external/easypost-php-2.1.0/',
			'external/easypost-php-2.1.1/',
			'external/easypost-php-2.1.2/',
			'external/easypost-php-3.0.0/',
			'external/easypost-php-3.0.1/',
			'external/easypost-php-3.0.2/',
			'external/easypost-php-3.0.3/',
            'external/editors/connector/',
            'external/editors/FCKeditor/',
            'external/editors/ckeditor/images',
            'external/editors/ckeditor/skins/office2003',
            'external/editors/ckeditor/skins/v2',
            'external/editors/ckeditor402',
            'external/editors/images/',
            'external/facebook-php-sdk-3.2.2/',
            'external/fedex-php/',
            'external/fedex-phpv13/',
            'external/flowplayer3/',
            'external/flowplayer-3.2.12/',
            'external/flowplayer-3.2.15/',
            'external/flowplayer-3.2.16/',
            'external/iepngfix2/',
			'external/html5forms/',
            'external/magpierss/',
            'external/less.php/bin//',
            'external/lesshat/',
            'external/minify/min_extras/',
            'external/phpThumb/demo/',
            'external/phpThumb/docs/',
            'external/phpThumb/fonts/',
            'external/phpThumb/images/',
            'external/Respond-1.3.0/',
            'external/SimpleAjaxUploader/',
            'external/Smarty/',
            'external/Smarty-2/',
            'external/Smarty-3.1.4/',
            'external/Smarty-3.1.7/',
            'external/Smarty-3.1.8/',
            'external/Smarty-3.1.11/',
            'external/Smarty-3.1.12/',
            'external/Smarty-3.1.13/',
            'external/Smarty-3.1.14/',
            'external/Smarty-3.1.15/',
            'external/Smarty-3.1.18/',
            'external/Smarty-3.1.19/',
            'external/Smarty-3.1.21/',
            'external/swfobject/',
            'external/Swift/',
            'external/Swift-4/',
            'external/Swift-4.0.5/',
            'external/Swift-4.1.1/',
            'external/Swift-4.1.3/',
            'external/Swift-4.1.4/',
            'external/Swift-4.1.5/',
            'external/Swift-4.1.6/',
            'external/Swift-4.1.7/',
            'external/Swift-4.2.1/',
            'external/Swift-4.2.2/',
            'external/Swift-4.2.3/',
            'external/Swift-4.3.0/',
            'external/Swift-4.3.1/',
            'external/Swift-5.0.0/',
            'external/Swift-5.0.1/',
            'external/Swift-5.1.0/',
            'external/Swift-5.2.0/',
            'external/swiftmailer-5.2.1/',
            'external/swiftmailer-5.3.1/',
            'external/swiftmailer-5.4.0/',
			'external/swiftmailer-5.4.1/',
            'external/yui3/',
            'external/lissa/',
            'external/yui/build/',
            'external/yui/3.4.0/',
            'external/yui/3.7.2/',
            'external/yui/3.7.3/',
            'external/yui/3.8.0/',
            'external/yui/3.9.0/',
            'external/yui/3.9.1/',
            'external/yui/3.10.0/',
            'external/yui/3.10.1/',
            'external/yui/3.11.0/',
            'external/yui/3.13.0/',
            'external/yui/3.16.0/',
            'external/yui/3.17.2/',
        );
        foreach ($olddirs as $dir) {
            if (expUtil::isReallyWritable(BASE.$dir)) {
                expFile::removeDirectory(BASE.$dir);
            }
        }

		return ($files_removed?$files_removed:gt('No'))." ".gt("obsolete files and folders were removed.");
		
	}
}

?>
