{*
 * Copyright (c) 2004-2021 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

{css unique="announcement" link="`$asset_path`css/announcement.css"}
{literal}
    .close-icon {
      cursor: pointer;
    }
{/literal}
{/css}

<div class="module news announcement">
    {if $moduletitle && !($config.hidemoduletitle xor $smarty.const.INVERT_HIDE_TITLE)}<{$config.heading_level|default:'h1'}>{/if}
    {rss_link}
    {if $moduletitle && !($config.hidemoduletitle xor $smarty.const.INVERT_HIDE_TITLE)}{$moduletitle}</{$config.heading_level|default:'h1'}>{/if}

    {permissions}
    <div class="module-actions">
        {if $permissions.create}
            {icon class="add" action=edit rank=1 text="Add a news post"|gettext}
        {/if}
        {if $permissions.manage}
            {if !$config.disabletags}
                {icon controller=expTag class="manage" action=manage_module model='news' text="Manage Tags"|gettext}
            {/if}
            {*{if $rank == 1}*}
            {if $config.order == 'rank'}
                {ddrerank items=$page->records model="news" label="News Items"|gettext}
            {/if}
            {icon class=view action=scriptaction text='Reveal Hidden Alerts'|gettext title='Reveal Hidden Alerts'|gettext onclick="restoreNodes();"}
        {/if}
        {if $permissions.showUnpublished}
            {icon class="view" action=showUnpublished text="View Expired/Unpublished News"|gettext}
        {/if}
    </div>
    {/permissions}
    {if $config.moduledescription != ""}
   		{$config.moduledescription}
   	{/if}
    {$myloc=serialize($__loc)}
    {foreach from=$page->records item=item}
        {*<div class="item announcement{if !$item->approved && $smarty.const.ENABLE_WORKFLOW} unapproved{/if}{if $item->is_featured} featured{/if}">*}
        <div id="alert-{$item->sef_url}" class="item card{if !$item->approved && $smarty.const.ENABLE_WORKFLOW} unapproved{/if}{if newsController::getVar('alert-'|cat:$item->sef_url)} d-none{/if}">
            <div class="card-header bg-{if $item->is_featured}danger{else}{cycle values="info,success"}{/if}">
                {if $config.hidefeatured && $item->is_featured}
                    <span class="float-end clickable close-icon" data-effect="fadeOut"><i class="fas fa-times"></i></span>
                {/if}
                <{$config.item_level|default:'h2'} class="card-title text-white">{$item->title}</{$config.item_level|default:'h2'}>
            </div>
            <div class="card-body">
            {if $item->isRss != true}
                {permissions}
                    <div class="item-actions">
                        {if $permissions.edit || ($permissions.create && $item->poster == $user->id)}
                            {if $item->revision_id > 1 && $smarty.const.ENABLE_WORKFLOW}<span class="revisionnum approval" title="{'Viewing Revision #'|gettext}{$item->revision_id}">{$item->revision_id}</span>{/if}
                            {if $myloc != $item->location_data}
                                {if $permissions.manage}
                                    {icon action=merge id=$item->id title="Merge Aggregated Content"|gettext}
                                {else}
                                    {icon img='arrow_merge.png' title="Merged Content"|gettext}
                                {/if}
                            {/if}
                            {icon action=edit record=$item}
                            {icon action=copy record=$item}
                        {/if}
                        {if $permissions.delete || ($permissions.create && $item->poster == $user->id)}
                            {icon action=delete record=$item}
                        {/if}
                        {if !$item->approved && $smarty.const.ENABLE_WORKFLOW && $permissions.approve && ($permissions.edit || ($permissions.create && $item->poster == $user->id))}
                            {icon action=approve record=$item}
                        {/if}
                    </div>
                {/permissions}
            {/if}
            <div class="bodycopy">
                {if $config.ffloat != "Below"}
                    {filedisplayer view="`$config.filedisplay`" files=$item->expFile record=$item is_listing=1}
                {/if}
                {$link = '<a href="'|cat:makeLink([controller=>news, action=>show, title=>$item->sef_url])|cat:'"><em>'|cat:'(read more)'|gettext|cat:'</em></a>'}
                {if $config.usebody==1}
                    {*<p>{$item->body|summarize:"html":"paralinks"}</p>*}
                {elseif $config.usebody==3}
                    {$item->body|summarize:"html":"parapaged":$link}
                {elseif $config.usebody==2}
                    <p>{$item->body|summarize:"html":"parahtml":$link}</p>
				{else}
                    {$item->body}
                {/if}
                {if $config.ffloat == "Below"}
                    {filedisplayer view="`$config.filedisplay`" files=$item->expFile record=$item is_listing=1}
                {/if}
            </div>
            {if $config.enable_tweet}
                <a href="https://twitter.com/share" class="twitter-share-button" data-url="{link action=show title=$item->sef_url}" data-text="{$item->title}"{if $config.layout} data-count="{$config.layout}"{/if}{if $config.size} data-size="{$config.size}"{/if} data-lang="en">{'Tweet'|gettext}</a>
                {script unique='tweet_src'}
                {literal}
                    !function(d,s,id){
                        var js,fjs=d.getElementsByTagName(s)[0];
                        if(!d.getElementById(id)){
                            js=d.createElement(s);
                            js.id=id;
                            js.src="https://platform.twitter.com/widgets.js";
                            fjs.parentNode.insertBefore(js,fjs);
                        }
                    }(document,"script","twitter-wjs");
                {/literal}
                {/script}
            {/if}
            {clear}
            </div>
        </div>
    {/foreach}
</div>

{if $config.hidefeatured}
    {script unique='hide_featured'}
    {literal}
        $('.close-icon').on('click',function() {
            $(this).closest('.card').addClass('d-none');
            $.post(eXp.PATH_RELATIVE+"index.php?ajax_action=1&module=news&action=setVar", { var:$(this).closest('.card').attr('id'), val:1 });
        })

        function restoreNodes() {
            $( '.item.card.d-none' ).each(function(  ) {
                $( this ).removeClass( "d-none" );
                $.post(eXp.PATH_RELATIVE+"index.php?ajax_action=1&module=news&action=setVar", { var:$(this).attr('id'), val:0 });
            });
        }
    {/literal}
    {/script}
{/if}