<?php

##################################################
#
# Copyright (c) 2004-2021 OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# GPL: http://www.gnu.org/licenses/gpl.txt
#
##################################################

/**
 * Smarty {editorinclude} function plugin
 *
 * Type:     function<br>
 * Name:     editorinclude<br>
 * Purpose:  include an external editor
 *
 * @param         $params
 * @param \Smarty $smarty
 *
 * @package Smarty-Plugins
 * @subpackage Function
 */
function smarty_function_editorinclude($params,&$smarty) {
	if (file_exists(BASE.'themes/'.DISPLAY_THEME.'/editors/'.$params['filename'])) {
        echo ( PATH_RELATIVE.'themes/'.DISPLAY_THEME.'/editors/'.$params['filename'] );
    } elseif (file_exists(BASE.'external/editors/'.$params['filename'])) {
        echo ( PATH_RELATIVE.'external/editors/'.$params['filename'] );
    } else {
        echo ($params['filename']);
    }
}
