<?php
##################################################
#
# Copyright (c) 2004-2022 OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# GPL: http://www.gnu.org/licenses/gpl.txt
#
##################################################

spl_autoload_register(function ($class) {
    // Don't interfere with other autoloaders
    if (0 !== strpos($class, 'Mpdf')) {
        return;
    }

    $class = str_replace('Mpdf\\', '', $class);
    $path = __DIR__.'/'.str_replace('_', '/', $class).'.php';

    if (!file_exists($path)) {
        return;
    }

    require $path;

});
