<?php

##################################################
#
# Copyright (c) 2004-2014 OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# GPL: http://www.gnu.org/licenses/gpl.txt
#
##################################################

class sermonseries extends expRecord {

	public $table = 'sermonseries';
    public $has_many = array('sermons');

    protected $attachable_item_types = array(
        'content_expFiles'=>'expFile'
    );

	public $validates = array(	
		'presence_of'=>array(
			'title'=>array('message'=>'Title is a required field.'),
		)
    );

    public function afterDelete() {
        // if we delete the sermonseries, we must take ALL the sermons with it!
        $ser = new sermons();
        $sermons = $ser->find('all','sermonseries_id='.$this->id);
        foreach ($sermons as $sermon) {
            $sermon->delete();
        }
    }

}

?>
