{*
 * Copyright (c) 2004-2014 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

<div id="editfile" class="module sermons edit">
    {if $record->id != ""}<h1>{'Editing'|gettext} '{$record->title}'</h1>{else}<h1>{'New Sermon'|gettext}</h1>{/if}
    {form action=update_sermon}
        {control type=hidden name=id value=$record->id}
        {*{control type=hidden name=sermonseries_id value=$record->sermonseries_id}*}
        {control type=hidden name=rank value=$record->rank}
        <div id="editsermon-tabs" class="yui-navset exp-skin-tabview hide">
            <ul class="yui-nav">
                <li class="selected"><a href="#tab1"><em>{'General'|gettext}</em></a></li>
                <li><a href="#tab2"><em>{'Date'|gettext}</em></a></li>
                {if !($config.hide_audio && $config.hide_slides && $config.hide_notes && $config.hide_guide)}
                    <li><a href="#tab3"><em>{'Attachments'|gettext}</em></a></li>
                {/if}
                {if $config.show_comments}
                    <li><a href="#tab4"><em>{'Comments'|gettext}</em></a></li>
                {/if}
                <li><a href="#tab5"><em>{'SEO'|gettext}</em></a></li>
            </ul>            
            <div class="yui-content yui3-skin-sam">
                <div id="tab1">
                    {control type="dropdown" name="sermonseries_id" label="Sermon Series"|gettext items=$serieslist value=$record->sermonseries_id}
                    {control type=text name=title label="Sermon Title"|gettext value=$record->title}
                    {if $config.show_bible}
                        {control type=text name=bible label="Sermon Scripture Reference(s)"|gettext value=$record->bible}
                    {/if}
                    {if $config.show_speaker}
                        {control type=dropdown name=speaker_id label="Speaker"|gettext items=$speakers value=$record->speaker_id}
                    {/if}
                    {if $config.show_service}
                        {control type=dropdown name=service_id label="Service"|gettext items=$services value=$record->service_id}
                    {/if}
                    {if !$config.hide_summary}
                        {control type=html name=summary label="Summary"|gettext value=$record->summary}
                    {/if}
                    {if $config.show_outline}
                        {control type=html name=body label="Outline"|gettext value=$record->body}
                    {/if}
                    {if !$config.disabletags}
                        {control type="tags" value=$record}
                    {/if}
                    {if $config.enable_ealerts}
                        {control type="checkbox" name="send_ealerts" label="Send E-Alert?"|gettext value=1}
                    {/if}
                    {if $config.enable_auto_status}
                   	    {control type="checkbox" name="send_status" label="Post as Facebook Status?"|gettext value=1}
                   	{/if}
                    {if $config.enable_auto_tweet}
                   	    {control type="checkbox" name="send_tweet" label="Post as a Tweet?"|gettext value=1}
                   	{/if}
                </div>
                <div id="tab2">
                    {control type=yuidatetimecontrol name=date showtime=false label="Date"|gettext value=$record->date}
                </div>
                {if !($config.hide_audio && $config.hide_slides && $config.hide_notes && $config.hide_guide)}
                    <div id="tab3">
                        <h2>{'Sermon Attachments'|gettext}</h2>
                        {if !$config.hide_audio}
                            {control id="sermonaudio" type="files" name="sermonaudio" label="Audio/Video"|gettext subtype=sermonaudio limit="2" value=$record->expFile}
                        {/if}
                        {if !$config.hide_slides}
                            {control id="powerpointslides" type="files" name="powerpointslides" label="Slides"|gettext subtype=powerpointslides limit="64" value=$record->expFile description='PowerPoint slides saved/uploaded as images will be displayed as a slideshow'|gettext}
                        {/if}
                        {if !$config.hide_notes}
                            {control id="sermonnotes" type="files" name="sermonnotes" label="Notes"|gettext subtype=sermonnotes limit="1" value=$record->expFile}
                        {/if}
                        {if !$config.hide_guide}
                            {control id="fusionstudyguide" type="files" name="fusionstudyguide" label="Study Guide"|gettext subtype=fusionstudyguide limit="1" value=$record->expFile}
                        {/if}
                    </div>
                {/if}
                {if $config.show_comments}
                    <div id="tab4">
                        {control type=text name=blogtitle label="Comments Title"|gettext value=$record->blogtitle}
                        {control type=html name=blogbody label="Comments"|gettext value=$record->blogbody}
                    </div>
                {/if}
                <div id="tab5">
                    <h2>{'SEO Settings'|gettext}</h2>
                    {control type="text" name="sef_url" label="SEF URL"|gettext value=$record->sef_url description='If you don\'t put in an SEF URL one will be generated based on the title provided. SEF URLs can only contain alpha-numeric characters, hyphens, forward slashes, and underscores.'|gettext}
                    {control type="text" name="canonical" label="Canonical URL"|gettext value=$record->canonical description='Helps get rid of duplicate search engine entries'|gettext}
                    {control type="text" name="meta_title" label="Meta Title"|gettext value=$record->meta_title description='Override the item title for search engine entries'|gettext}
                    {control type="textarea" name="meta_description" label="Meta Description"|gettext rows=5 cols=35 value=$record->meta_description description='Override the item summary for search engine entries'|gettext}
                    {control type="textarea" name="meta_keywords" label="Meta Keywords"|gettext rows=5 cols=35 value=$record->meta_keywords description='Comma separated phrases - overrides site keywords and item tags'|gettext}
                    {control type="checkbox" name="meta_noindex" label="Do Not Index"|gettext|cat:"?" checked=$section->meta_noindex value=1 description='Should this page be indexed by search engines?'|gettext}
                    {control type="checkbox" name="meta_nofollow" label="Do Not Follow Links"|gettext|cat:"?" checked=$section->meta_nofollow value=1 description='Should links on this page be indexed and followed by search engines?'|gettext}
                </div>
            </div>
        </div>
        <div class="loadingdiv">{'Loading Sermon'|gettext}</div>
        {control type=buttongroup submit="Save Sermon"|gettext cancel="Cancel"|gettext}
    {/form}   
</div>

{script unique="blogtabs" yui3mods=1}
{literal}
    EXPONENT.YUI3_CONFIG.modules.exptabs = {
        fullpath: EXPONENT.JS_RELATIVE+'exp-tabs.js',
        requires: ['history','tabview','event-custom']
    };

	YUI(EXPONENT.YUI3_CONFIG).use('exptabs', function(Y) {
        Y.expTabs({srcNode: '#editsermon-tabs'});
		Y.one('#editsermon-tabs').removeClass('hide');
		Y.one('.loadingdiv').remove();
    });
{/literal}
{/script}
