<?php

##################################################
#
# Copyright (c) 2004-2014 OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# GPL: http://www.gnu.org/licenses/gpl.txt
#
##################################################

/**
 * @subpackage Upgrade
 * @package Installation
 */

/**
 * This is the class upgrade_sermonseries
 */
class upgrade_sermonseries extends upgradescript {
	protected $from_version = '0.0.0';
//	protected $to_version = '2.2.2';  // sermonseries module was consolidated in v2.2.2
    public $optional = true;

	/**
	 * name/title of upgrade script
	 * @return string
	 */
	static function name() { return "Upgrade Sermon Series modules to new consolidated format"; }

	/**
	 * generic description of upgrade script
	 * @return string
	 */
	function description() { return "The Sermon Series module originally had two controllers which were merged into one.  This Script updates references fot the old Sermons Controller to the consolidated Sermon Series Controller."; }

    /**
   	 * This routine should perform additional test(s) to see if upgrade script should be run (files/tables exist, etc...)
   	 * @return bool
   	 */
   	function needed() {
        global $db;

//        return true;
        $needed = $db->countObjects('sermons',"location_data LIKE '%s:3:\"mod\";s:7:\"sermons\";%'");
        $needed += $db->countObjects('search',"ref_module = 'sermons'");
        if ($needed) {
            return true;
        } else return false;
   	}

	/**
	 * Converts all sermons controller references into sermonseries controller
     *
	 * @return bool
	 */
	function upgrade() {
	    global $db;

		// convert each sermons references to sermonseries
        $sermons = $db->selectObjects('sermons',"location_data LIKE '%s:3:\"mod\";s:7:\"sermons\";%'");
        $sermons_updated = 0;
        foreach ($sermons as $sermon) {
            $loc = expUnserialize($sermon->location_data);
            $loc->mod = 'sermonseries';
            $sermon->location_data = serialize($loc);
            $db->updateObject($sermon,'sermons');
            $sermons_updated += 1;
        }

        // update search index if needed
        $search_updated = '';
        if ($db->countObjects('search',"ref_module = 'sermons'")) {
            $db->delete('search',"ref_module LIKE '%sermons%'");
            $ss = new sermonseriesController();
            $ss->addContentToSearch();
            $search_updated = ' ' . gt('and Search index was also updated');
        }

		return ($sermons_updated?$sermons_updated:gt('No'))." ".gt("Sermons updated") . $search_updated;
	}
}

?>
