<?php

##################################################
#
# Copyright (c) 2004-2014 OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# GPL: http://www.gnu.org/licenses/gpl.txt
#
##################################################

class sermonseriesController extends expController {

	public $useractions = array(
		'showall'=>'Show all',
		'recentSermon'=>'Recent Sermon'
	);

	public $remove_configs = array(
        'categories',
        'comments',
//        'facebook',
        'files',
        'rss',
//        'twitter',
    );  // all options: ('aggregation','categories','comments','ealerts','facebook','files','module_title','pagination','rss','tags','twitter',)
    public $add_permissions = array(
	    'import'=>'Import Data from Other Modules',
    );
//    public $codequality = 'beta';

    static function displayname() { return "Sermon Series"; }
    static function description() { return " Lets you group a series of sermons and their associated files (audio, ppt, etc.)"; }
    static function author() { return "Jonathan Worent - Inspired Bytes"; }
    static function isSearchable() { return true; }

    /**
     * Shows sermon series
     *
     */
    function showall() {
        expHistory::set('viewable', $this->params);
        $modelname = $this->basemodel_name;
        $where = $this->aggregateWhereClause();
        $limit = isset($this->config['limit']) ? $this->config['limit'] : 10;
        $order = isset($this->config['order']) ? $this->config['order'] : 'rank';
        $dir   = isset($this->config['dir']) ? $this->config['dir'] : 'DESC';
        $page = new expPaginator(array(
                    'model'=>$modelname,
                    'where'=>$where, 
                    'limit'=>$limit,
                    'order'=>$order,
                    'dir'=>$dir,
                    'page'=>(isset($this->params['page']) ? $this->params['page'] : 1),
                    'controller'=>$this->baseclassname,
                    'action'=>$this->params['action'],
                    'src'=>$this->loc->src,
                    'columns'=>array('ID#'=>'id','Title'=>'title', 'Body'=>'body'),
                )
        	);
        
        //FIXME if series are ordered by date, we need to re-order them based on sermon dates, NOT series item date
        //  we don't need all the sermons, just the count, the newest date and the oldest date
        $sermons = new sermons();
        foreach($page->records as $i=>$record) {
//			$page->records[$i]->sermons = $sermons->find('all', '`sermonseries_id`='.$record->id, '`date` DESC');
            $page->records[$i]->sermonscount = $sermons->find('count', '`sermonseries_id`='.$record->id, '`date` DESC');
            $sermonfirst = $sermons->find('first', '`sermonseries_id`='.$record->id, '`date` ASC');
            $page->records[$i]->sermonfirst = !empty($sermonfirst->date) ? $sermonfirst->date : null;
            $sermonlast = $sermons->find('first', '`sermonseries_id`='.$record->id, '`date` DESC');
            $page->records[$i]->sermonlast = !empty($sermonlast->date) ? $sermonlast->date : null;
        }
        if ($order != 'rank') $page->records = expSorter::sort(array('array' => $page->records, 'sortby' => 'sermonlast', 'order' => 'DESC', 'ignore_case' => true));
        assign_to_template(array(
            'page'=>$page,
            'items'=>$page->records,
            'modelname'=>$modelname,
            'rank'=>($order==='rank')?1:0
        ));
    }

    /**
     * Highlights selected sermon number from specific sermon series
     *   based on sermon series and page/sermon #
     *
     */
    function show() {
        $id = isset($this->params['title']) ? $this->params['title'] : $this->params['id'];
	    $series = new sermonseries($id);
        
        $sermons = new sermons();
        $series->sermons = $sermons->find('all', '`sermonseries_id`='.$series->id, '`date` ASC');
        foreach ($series->sermons as $key=>$sermon) {
            $series->sermons[$key]->speakers = $sermon->speakers->find('first','id = '.$sermon->speaker_id);
            $series->sermons[$key]->services = $sermon->services->find('first','id = '.$sermon->service_id);
        }

        $this->config = expConfig::getConfig($this->loc);
        $this->loc = expUnserialize($series->location_data);

        assign_to_template(array(
            'record'=>$series,
            'page'=>(!empty($this->params['page']) ? $this->params['page'] : count($series->sermons)),
            'config'=>$this->config
        ));
    }

    /**
     * Shows most recent sermon/sermon series
     *
     */
    function recentSermon() {
        $sermons = new sermons();
        $sermon = $sermons->find('first', $this->aggregateWhereClause(), '`date` DESC');

        $error = false;
        if (empty($sermon->sermonseries_id)) {
//            flash('notice', gt('There appear to be no sermons. Please add a sermon series and a sermon before using the Recent Sermons view.'));
//            redirect_to(array('controller'=>'sermonseries','action'=>'showall','src'=>$this->loc->src));
            $series = new sermonseries();
            $series->sermons = array();
            $error = true;
        } else {
            $series = new sermonseries($sermon->sermonseries_id);
            $series->sermon = $sermon;
            $series->sermons = $sermons->find('all', '`sermonseries_id`='.$series->id, '`date` ASC');

            $this->config = expConfig::getConfig($this->loc);
            $this->loc = expUnserialize($series->location_data);
        }

        assign_to_template(array(
            'record'=>$series,
            'page'=>count($series->sermons),
            'config'=>$this->config,
            'error'=>$error
        ));
    }

    public function showall_by_tags() {
        $this->basemodel_name = 'sermons';
        parent::showall_by_tags();
    }

    function getRSSContent() {
        include_once(BASE.'external/mp3file.php');

        // setup the where clause for looking up     records.
//        $this->loc->mod = 'sermons';
        $where = $this->aggregateWhereClause();
        $order = 'date ASC';
        $ser = new sermons();
        $items = $ser->find('all',$where, $order);

        //Convert the items to rss items
        $rssitems = array();
//        $pages = array();
        foreach ($items as $key => $item) {
            $rss_item = new FeedItem();
//            if (empty($pages[$item->sermonseries->sef_url])) {
//                $pages[$item->sermonseries->sef_url] = 1;
//            } else {
//                $pages[$item->sermonseries->sef_url]++;
//            }
//            $page = $pages[$item->sermonseries->sef_url];
            // Add the basic data
//            $rss_item->link = makeLink(array('controller'=>$this->baseclassname, 'action'=>'show', 'title'=>$item->sermonseries->sef_url, 'page'=>$page));
            $rss_item->link = makeLink(array('controller'=>$this->baseclassname, 'action'=>'show_sermon', 'title'=>$item->sef_url));
            $rss_item->author = user::getUserById($item->poster)->firstname.' '.user::getUserById($item->poster)->lastname;
            $rss_item->authorEmail = user::getEmailById($item->poster);
//            $rss_item->date = isset($item->date) ? date('c',$item->date) : date('c', $item->created_at);
            $rss_item->date = isset($item->date) ? $item->date : $item->created_at;
            if (!empty($item->sermonseries->title)) $rss_item->category = array($item->sermonseries->title);

            if (!empty($this->params['type']) && $this->params['type'] == 'comments') {
                $rss_item->title = expString::convertSmartQuotes($item->blogtitle);
                $rss_item->description = expString::convertSmartQuotes($item->blogbody);
            } else {
                $rss_item->title = expString::convertSmartQuotes($item->title);
                if ($this->config['show_outline'] & $item->body != "") {
                    $body = $item->body;
                } else {
                    $body = $item->summary;
                }
                if ($this->config['show_bible'] & $item->bible != "") {
                    $body = '<h4>' . $item->bible . '</h4><br>' . $body;
                }
                $rss_item->description = expString::convertSmartQuotes($body);
                // Add the attachment/enclosure info
                $rss_item->enclosure = new Enclosure();
                $rss_item->enclosure->url = !empty($item->expFile['sermonaudio'][0]->url) ? $item->expFile['sermonaudio'][0]->url : '';
                $rss_item->enclosure->length = !empty($item->expFile['sermonaudio'][0]->filesize) ? $item->expFile['sermonaudio'][0]->filesize : '';
                $rss_item->enclosure->type = !empty($item->expFile['sermonaudio'][0]->mimetype) ? $item->expFile['sermonaudio'][0]->mimetype : '';
                if ($rss_item->enclosure->type == 'audio/mpeg') $rss_item->enclosure->type = 'audio/mpg';

                // Add iTunes info
                $rss_item->itunes = new iTunes();
                $rss_item->itunes->subtitle = expString::convertSmartQuotes($item->title);
                $rss_item->itunes->summary = expString::convertSmartQuotes($item->body);
                $rss_item->itunes->author = user::getUserById($item->poster)->firstname.' '.user::getUserById($item->poster)->lastname;
                $tags = '';
                foreach ($item->expTag as $tag) {
                    $tags .= $tag->title.", ";
                }
                if (!empty($tags)) {
                    $rss_item->itunes->keywords = $tags;
                }
                if (($rss_item->enclosure->type == "audio/mpg") && (file_exists(BASE.$item->expFile['sermonaudio'][0]->directory.$item->expFile['sermonaudio'][0]->filename))) {
                    $mp3 = new mp3file(BASE.$item->expFile['sermonaudio'][0]->directory.$item->expFile['sermonaudio'][0]->filename);
                    $id3 = $mp3->get_metadata();
                    if (($id3['Encoding']=='VBR') || ($id3['Encoding']=='CBR')) {
                        $rss_item->itunes->duration = $id3['Length mm:ss'];
                    }
                } else {
                    $rss_item->itunes->duration = 'Unknown';
                }
            }

            // Add the item to the array.
            if (!empty($rss_item->title)) $rssitems[$key] = $rss_item;

        }
        $rssitems = array_reverse($rssitems);
        return $rssitems;
    }

    /**
     * add all module items to search index
     *
     * @return int
     */
    function addContentToSearch() {
//        global $db, $router;
        global $db;

        $count = parent::addContentToSearch();
        $model = new sermons(null, false, false);
        $where = (!empty($this->params['id'])) ? 'id=' . $this->params['id'] : null;
        $content = $db->selectArrays($model->tablename, $where);
        foreach ($content as $cnt) {
            $origid = $cnt['id'];
            unset($cnt['id']);
            $cnt['body'] = $cnt['summary'] . ' ' . $cnt['body'] . ' ' . $cnt['blogbody'];
           //build the search record and save it.
            $sql = "original_id=" . $origid . " AND ref_module='" . $this->baseclassname . "'";
            $oldindex = $db->selectObject('search', $sql);
            if (!empty($oldindex)) {
                $search_record = new search($oldindex->id, false, false);
                $search_record->update($cnt);
            } else {
                $search_record = new search($cnt, false, false);
            }

            //build the search record and save it.
            $search_record->original_id = $origid;
            $search_record->posted = empty($cnt['created_at']) ? null : $cnt['created_at'];
            // get the location data for this content
            if (isset($cnt['location_data'])) $loc = expUnserialize($cnt['location_data']);
            $src = isset($loc->src) ? $loc->src : null;
            if (!empty($cnt['sef_url'])) {
                $link = str_replace(URL_FULL, '', makeLink(array('controller' => $this->baseclassname, 'action' => 'show_sermon', 'title' => $cnt['sef_url'])));
            } else {
                $link = str_replace(URL_FULL, '', makeLink(array('controller' => $this->baseclassname, 'action' => 'show_sermon', 'id' => $origid, 'src' => $src)));
            }
//	        if (empty($search_record->title)) $search_record->title = 'Untitled';
            $search_record->view_link = $link;
            $search_record->ref_module = $this->baseclassname;
            $search_record->category = $this->searchName();
//            $search_record->ref_type = $this->searchCategory();
            $search_record->ref_type = 'sermon';
            $search_record->save();
            $count += 1;
        }

        return $count;
    }

    /**
     * method to import filedownload entries into a sermon module as sermons
     * first display all the filedownload modules on the site
     *
     */
    public function import_filedownloads() {
        $pullable_modules = expModules::listInstalledControllers('filedownload');
        $modules = new expPaginator(array(
            'records' => $pullable_modules,
            'controller' => $this->loc->mod,
            'order'   => isset($this->params['order']) ? $this->params['order'] : 'section',
            'dir'     => isset($this->params['dir']) ? $this->params['dir'] : '',
            'page'    => (isset($this->params['page']) ? $this->params['page'] : 1),
            'columns' => array(
                gt('Title') => 'title',
                gt('Page')  => 'section'
            ),
        ));

        assign_to_template(array(
            'modules'              => $modules,
        ));
    }

    /**
     * method to display all the filedownloads in the selected modules
     *
     */
    public function import_filedownloads_select() {
        $sql = '';
        if (!empty($this->params['aggregate'])) {
            $sql .= '(';
        } else {
            expHistory::back();
        }
        $sql .= "location_data ='" . serialize($this->loc) . "'";

        if (!empty($this->params['aggregate'])) {
            foreach ($this->params['aggregate'] as $src) {
                $loc = expCore::makeLocation('filedownload', $src);
                $sql .= " OR location_data ='" . serialize($loc) . "'";
            }

            $sql .= ')';
        }

        $files = new expPaginator(array(
            'model'=>'filedownload',
            'where'=>$sql,
            'categorize'=>true,
            'groups'=>!isset($this->params['group']) ? array() : array($this->params['group']),
            'page'=>(isset($this->params['page']) ? $this->params['page'] : 1),
            'controller'=>'filedownload',
            'action'=>$this->params['action'],
            'src'=>$this->loc->src,
            'columns'=>array(
                gt('Title')=>'title',
                gt('Category')=>'id',
            ),
        ));

        $modelname = $this->basemodel_name;
        $where = $this->aggregateWhereClause();
        $limit = isset($this->config['limit']) ? $this->config['limit'] : null;
        $order = isset($this->config['order']) ? $this->config['order'] : 'rank';
        $dir   = isset($this->config['dir']) ? $this->config['dir'] : 'ASC';
        $series = new expPaginator(array(
                    'model'=>$modelname,
                    'where'=>$where,
//                    'limit'=>$limit,
                    'order'=>$order,
                    'dir'=>$dir,
                    'controller'=>$this->baseclassname,
                    'action'=>$this->params['action'],
                    'src'=>$this->loc->src,
                    'columns'=>array('ID#'=>'id','Title'=>'title', 'Body'=>'body'),
                )
        	);
        $serieslist = array();
        if (count($series->records)) foreach ($series->records as $ser) {
            $serieslist[$ser->id] = $ser->title;
        }

        assign_to_template(array(
            'files'=>$files,
            'serieslist'=>$serieslist,
        ));
    }

    /**
     * method to import all the selected filedownloads into sermons
     * we also create sermonseries from the cats
     *
     */
    public function import_filedownloads_process() {
        // read in each record and convert categories to create a sermon series, then create a sermon
        $imported = 0;
        foreach ($this->params['file'] as $fileid) {
            $filedownload = new filedownload($fileid);
            if (!empty($filedownload->id)) {
                if (!empty($this->params['createseries']) && !empty($filedownload->expCat)) {
                    // create a sermonseries if no match exists
                    $series = $this->sermonseries->find('first','title="'.$filedownload->expCat[0]->title.'"');
                    if (empty($series)) {
                        $series = new sermonseries();
                        $series->update(array('title'=>$filedownload->expCat[0]->title,'location_data'=>serialize($this->loc)));
                    }
                    $seriesid = $series->id;
                } else {
                    $seriesid = $this->params['selectedseries'];;
                }

                // create a sermon object and save it
                $sermon = new sermons();
                $params = object2Array($filedownload);
                // parse out 1st line <p><div> of 'body' into scripture reference
                if (!empty($this->config['show_bible']) && $this->params['parse_scripture']) {
                    $params['bible'] = substr(expString::summarize($params['body'],'html','para'),0,-4);
                    $tmp_body = preg_replace('#^.*?</p>#is', '', $params['body'], 1);
                    if (!empty($tmp_body)) $params['body'] = $tmp_body;
                }
                unset ($params['id']);
                unset ($params['expCat']);
                $loc_data = expUnserialize($params['location_data']);
                $loc_data->mod = 'sermonseries';
                $loc_data->src = $this->loc->src;
                $params['location_data'] = serialize($loc_data);
                $params['sermonseries_id'] = $seriesid;
                $params['date'] = $params['publish'];
                $params['_validate'] = false;
                foreach ($params['expFile'] as $key=>$filetype) {
                    if ($key == 'downloadable') {
                        foreach ($filetype as $file) {
                            $params['expFile']['sermonaudio'][] = $file->id;
                        }
                        unset($params['expFile'][$key]);
                    }
                }
                $tagset = array();
                foreach ($params['expTag'] as $tag) {
                    $tagset[] = $tag->id;
                }
                $params['expTag'] = $tagset;
                $sermon->update($params);
                $imported++;
            }
        }
        flash('message', ($imported?$imported:gt('No'))." ".gt('Sermons imported from File Downloads'));
        $this->addContentToSearch();
        expHistory::back();
    }

    /**
     * method to import and attach blog entries into a sermon module as sermon comments
     *
     */
    public function import_blogs() {

        // select the exiting blog modules (like aggregation list?)

        // allow record selection? possibly some sort of 'mapper' sermon to blog title?
        // read in each record and manually assign a to sermon
        //   requires building a descriptive list of sermons w/ dates? for dropdown selection for each blog item?

    }

    /**
     * The aggregateWhereClause function creates a sql where clause which also includes aggregated module content
     *
     * @param string $type
     *
     * @return string
     */
    function aggregateWhereClause($type='') {
        $sql = '';

        if (empty($type)) $type = $this->basemodel_name;
        $type = 'sermonseries';
        if (!empty($this->config['aggregate'])) $sql .= '(';

        $this_loc = clone($this->loc);
        $this_loc->mod = $type;
        $sql .= "location_data ='" . serialize($this_loc) . "'";

        if (!empty($this->config['aggregate'])) {
            foreach ($this->config['aggregate'] as $src) {
                $loc = expCore::makeLocation($type, $src);
                $sql .= " OR location_data ='" . serialize($loc) . "'";
            }

            $sql .= ')';
        }

        return $sql;
    }

    public function edit_speaker() {
        $id = !empty($this->params['id']) ? $this->params['id'] : null;
        $speaker = new speakers($id);
        assign_to_template(array(
            'record'=> $speaker,
        ));
    }

    public function update_speaker() {
        $obj = new speakers($this->params['id']);
        $obj->update($this->params);
        expHistory::back();
    }

    public function manage_speakers() {
        expHistory::set('viewable', $this->params);

        $page = new expPaginator(array(
			'model'=>'speakers',
			'where'=>1,
            'limit'=>10,
            'page'=>(isset($this->params['page']) ? $this->params['page'] : 1),
            'controller'=>$this->params['controller'],
            'action'=>$this->params['action'],
        ));

		assign_to_template(array(
            'page'=>$page
        ));
    }

    public function delete_speaker() {
        if (empty($this->params['id'])) {
            flash('error', gt('Missing id for the Speaker you would like to delete'));
            expHistory::back();
        }

        $obj = new speakers($this->params['id']);
        $obj->delete();
        expHistory::back();
    }

    public function edit_service() {
        $id = !empty($this->params['id']) ? $this->params['id'] : null;
        $services = new services($id);
        assign_to_template(array(
            'record'=> $services,
        ));
    }

    public function update_service() {
        $obj = new services($this->params['id']);
        $obj->update($this->params);
        expHistory::back();
    }

    public function manage_services() {
        expHistory::set('viewable', $this->params);

        $page = new expPaginator(array(
			'model'=>'services',
			'where'=>1,
            'limit'=>10,
            'page'=>(isset($this->params['page']) ? $this->params['page'] : 1),
            'controller'=>$this->params['controller'],
            'action'=>$this->params['action'],
        ));

		assign_to_template(array(
            'page'=>$page
        ));
    }

    public function delete_service() {
        if (empty($this->params['id'])) {
            flash('error', gt('Missing id for the Service you would like to delete'));
            expHistory::back();
        }

        $obj = new services($this->params['id']);
        $obj->delete();
        expHistory::back();
    }

    /**
     * Highlights selected sermon number from specific sermon series
     *   based on sermon title and NOT series
     *
     */
    function show_sermon() {
        $id = isset($this->params['title']) ? $this->params['title'] : $this->params['id'];
        $thesermon = new sermons($id);
        $this->sermonseries = new sermonseries($thesermon->sermonseries->id);
        $this->sermonseries->sermons = $thesermon->find('all', '`sermonseries_id`='.$thesermon->sermonseries->id, '`date` ASC');
        foreach ($this->sermonseries->sermons as $key=>$sermon) {
            $this->sermonseries->sermons[$key]->speakers = $sermon->speakers->find('first','id = '.$sermon->speaker_id);
            $this->sermonseries->sermons[$key]->services = $sermon->services->find('first','id = '.$sermon->service_id);
        }
        $page = -1;
        for ($i=0; $i<count($this->sermonseries->sermons); $i++) {
            if ($thesermon->id == $this->sermonseries->sermons[$i]->id) {
                $page = $i + 1;
                break;
            }
        }

        $this->loc = expUnserialize($this->sermonseries->location_data);
        $this->config = expConfig::getConfig($this->loc);

        assign_to_template(array(
            'record'=>$this->sermonseries,
            'page'=>($page != -1 ? $page : count($this->sermonseries->sermons)),
            'config'=>$this->config,
        ));
    }

    /**
     * Collates series and sermon details for editing record
     *
     */
    function edit_sermon() {
        expHistory::set('editable', $this->params);
        $record = new sermons(!empty($this->params['sermon_id'])?$this->params['sermon_id']:null);
        if (!empty($this->params['copy'])) {
            $record->id = null;
            $record->sef_url = null;
        }
        if (empty($this->params['sermon_id'])) $record->sermonseries_id = $this->params['id'];

        // create list of sermon series
        $ss = new sermonseries($this->params['id']);
        $series = new expPaginator(array(
                    'model'=>'sermonseries',
                    'where'=>"location_data='".$ss->location_data."'",
                    'order'=>'rank',
                    'dir'=>'ASC',
                    'controller'=>'sermonseries',
//                    'action'=>$this->params['action'],
//                    'src'=>$this->loc->src,
//                    'columns'=>array('ID#'=>'id','Title'=>'title'),
                )
        	);
        $serieslist = array();
        if (count($series->records)) foreach ($series->records as $ser) {
            $serieslist[$ser->id] = $ser->title;
        }

        // create list of tags
        $taglist = expTag::getAllTags();

        // create list of speakers
        $spkr = new speakers();
        $spkrs = $spkr->find('all',1);
        $speakers = array();
        $speakers[0] = gt('No Speaker Assigned');
        foreach ($spkrs as $speaker) {
            $speakers[$speaker->id] = $speaker->title;
        }

        // create list of services
        $svc = new services();
        $svcs = $svc->find('all',1);
        $services = array();
        $services[0] = gt('No Service Assigned');
        foreach ($svcs as $service) {
            $services[$service->id] = $service->title;
        }

        assign_to_template(array(
            'record'=>$record,
            'serieslist'=>$serieslist,
            'taglist'=>$taglist,
            'speakers'=>$speakers,
            'services'=>$services,
        ));
    }

    function update_sermon() {
        $this->basemodel_name = 'sermons';
//        $this->params['id'] = $this->params['sermon_id'];
        $this->sermons = new sermons($this->params);
        parent::update();
    }

    function delete_sermon() {
        $this->basemodel_name = 'sermons';
//        $this->params['id'] = $this->params['sermon_id'];
        parent::delete();
    }

}

?>
