{*
 * Copyright (c) 2004-2014 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

    {pagelinks paginate=$page top=1}
    {foreach from=$page->records item=series name=sermonseries}
        <div class="item">
            {permissions}
                <div class="item-actions">
                    {if $permissions.edit || ($permissions.create && $series->poster == $user->id)}
                        {icon action=edit record=$series title="Edit this Sermon Series"|gettext}
                    {/if}
                    {if $permissions.delete || ($permissions.create && $eries->poster == $user->id)}
                        {icon action=delete record=$series title="Delete this Sermon Series"|gettext onclick="return confirm('Are you sure you want to delete this Sermon Series?');"}
                    {/if}
                </div>
            {/permissions}
            <a class="series" href="{link action=show title=$series->sef_url}" title="{$series->body|summarize:"html":"para"}">
                {if $series->expFile.preview[0] != ""}
                    {img class="preview-img" file_id=$series->expFile.preview[0]->id h=105 w=155}
                {else}
                    {img class="preview-img" src="`$asset_path`images/sermon.jpeg" h=105 w=155}
                {/if}
                <span class="series-title"><strong>{$series->title}</strong></span>
                <div class="series-info">
                    {if ($series->sermonscount) == 1}
                        <strong>{'Date'|gettext}:</strong> {$series->sermonfirst|format_date:"%b %e, %Y"}
                    {elseif !$series->sermonscount}
                    {else}
                        <strong>{'Dates'|gettext}:</strong> {$series->sermonfirst|format_date:"%b %e"} - {$series->sermonlast|format_date:"%b %e, %Y"}
                    {/if}
                    {br}
                    <strong>{'Sermons'|gettext}:</strong> {$series->sermonscount}
                </div>
            </a>
         </div>
    {/foreach}
    {pagelinks paginate=$page bottom=1}
    {clear}
