{*
 * Copyright (c) 2004-2014 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

{css unique="aggregation" corecss="tables"}

{/css}

<h2>{"Import sermons from File Downloads modules"|gettext}</h2>
<blockquote>
    {'Select the modules to import from.'|gettext}
</blockquote>
{form action="import_filedownloads_select"}
    <table class="exp-skin-table">
        <thead>
            <tr>
                <th><input type='checkbox' name='checkall' title="{'Select All/None'|gettext}" style="margin-left: 1px;" onchange="selectAll(this.checked)"></th>
                {$modules->header_columns}
            </tr>
        </thead>
        <tbody>
    {foreach from=$modules->records item=mod}
            <tr class="{cycle values="even,odd"}">
                <td width="20">
                    {control type="checkbox" name="aggregate[]" value=$mod->src}
                </td>
                <td>
                    {$mod->title}
                </td>
                <td>
                    {$mod->section}
                </td>
            </tr>
    {foreachelse}
            <tr><td colspan=3>{'There doesn\'t appear to be any filedownload modules installed that you can import sermons from'|gettext}</td></tr>
    {/foreach}
        </tbody>
    </table>
    {control type="buttongroup" submit="Import from Selected Modules"|gettext cancel="Cancel"|gettext}
{/form}

{script unique="aggregation"}
    function selectAll(val) {
        var checks = document.getElementsByName("aggregate[]");
        for (var i = 0; i < checks.length; i++) {
          checks[i].checked = val;
        }
    }
{/script}
