{*
 * Copyright (c) 2004-2014 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

    {$sermon = $record->sermons[$page-1]}
	<div class="item">
        <div class="sermons">
            {$filetype=$sermon->expFile.sermonaudio[0]->filename|regex_replace:"/^.*\.([^.]+)$/D":"$1"}
            {*{if $filetype == "mp3" || $filetype == "flv" || $filetype == "f4v" || $filetype == "mp4"}*}
                {*<a href="{$sermon->expFile.sermonaudio[0]->url}" style="display:block;width:360px;height:{if $filetype == "mp3"}26{else}240{/if}px;" class="filedownload-media"></a>*}
            {*{elseif $sermon->expFile.preview[0] != ""}*}
                {*{img class="preview-img" file_id=$sermon->expFile.preview[0]->id h=105 w=155}*}
            {*{else}*}
                {*{img class="preview-img" src="`$asset_path`images/sermon.jpeg" h=105 w=155}*}
            {*{/if}*}

            {if $filetype == "mp3"}
                <audio width="320" id="{$sermon->expFile.sermonaudio[0]->filename}" preload="none" controls="controls" src="{$smarty.const.PATH_RELATIVE}{$sermon->expFile.sermonaudio[0]->directory}{$sermon->expFile.sermonaudio[0]->filename}" type="audio/mp3">
                </audio>
            {elseif $filetype == "mp4" || $filetype == "webm" || $filetype == "ogv" || $filetype == "flv" || $filetype == "f4v"}
                <video width="360" height="240" src="{$smarty.const.PATH_RELATIVE}{$sermon->expFile.sermonaudio[0]->directory}{$sermon->expFile.sermonaudio[0]->filename}" type="{$sermon->expFile.sermonaudio[0]->mimetype}"
                    id="player{$sermon->expFile.sermonaudio[0]->id}"
                    {if $sermon->expFile.preview[0]->url}
                        poster="{$sermon->expFile.preview[0]->url}"
                    {/if}
                    controls="controls" preload="none">
                </video>
            {elseif $record->expFile.preview[0] != ""}
                {img class="preview-img" file_id=$record->expFile.preview[0]->id h=105 w=155}
            {else}
                {img class="preview-img" src="`$asset_path`images/sermon.jpeg" h=105 w=155}
            {/if}

            <div class="page-box">
                {'Select Message'|gettext}:
                {for $i=1; $i<=count($record->sermons); $i++}
                    {if $i != $page}
                        {if !empty($record->sermons[$i-1]->bible)}
                            {$bible = " (`$record->sermons[$i-1]->bible`)"}
                        {else}
                            {$bible = ''}
                        {/if}
                        <a class="s-pager" href="{link action=show title=$record->sef_url page=$i}" rel="{$i}" title="{$record->sermons[$i-1]->title|summarize:"html":"para"}{$bible}
    {$record->sermons[$i-1]->date|format_date:"%b %e, %Y"}">{$i}</a>
                    {else}
                        <span class="s-pager current">
                            {$i}
                        </span>
                    {/if}
                {/for}
            </div>
            <div class="sermon">
                {group label="Message"|gettext}
                    {*{group label="Details"|gettext}*}
                        <strong>{'Date'|gettext}:</strong> {$sermon->date|format_date:"%B %e, %Y"}
                        {br}<hr>
                        <strong>{'Message Title'|gettext}:</strong>
                        {$sermon->title}{br}
                        {permissions}
                            <div class="item-actions">
                                {if $permissions.edit || ($permissions.create && $record->poster == $user->id)}
                                    {icon class=edit action=edit_sermon record=$record sermon_id=$sermon->id title="Edit this Sermon"|gettext}
                                    {icon class=copy action=edit_sermon copy=1 record=$record sermon_id=$sermon->id title="Copy this Sermon"|gettext}
                                {/if}
                                {if $permissions.delete || ($permissions.create && $record->poster == $user->id)}
                                   {icon class=delete action=delete_sermon record=$record sermon_id=$sermon->id title="Delete this Sermon"|gettext onclick="return confirm('Are you sure you want to delete this Sermon?');"}
                                {/if}
                            </div>
                        {/permissions}
                        {if $config.enable_facebook_like}
                            <div id="fb-root"></div>
                            <div class="fb-like" data-href="{link action=show_sermon title=$sermon->sef_url}" data-send="false" data-width="{$config.fblwidth|default:'450'}" data-show-faces="{if $config.showfaces}true{else}false{/if}" data-font="{$config.font|default:''}"{if $config.color_scheme} data-colorscheme="{$config.color_scheme}"{/if}{if $config.verb} data-action="{$config.verb}"{/if}"></div>
                            {script unique='facebook_src'}
                            {literal}
                                (function(d, s, id) {
                                    var js, fjs = d.getElementsByTagName(s)[0];
                                    if (d.getElementById(id)) return;
                                    js = d.createElement(s); js.id = id;
                                    js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
                                    fjs.parentNode.insertBefore(js, fjs);
                                }(document, 'script', 'facebook-jssdk'));
                            {/literal}
                            {/script}
                        {/if}
                        {if $config.enable_tweet}
                            <a href="https://twitter.com/share" class="twitter-share-button" data-url="{link action=show_sermon title=$sermon->sef_url}" data-text="{$sermon->title}"{if $config.layout} data-count="{$config.layout}"{/if}{if $config.size} data-size="{$config.size}"{/if} data-lang="en">{'Tweet'|gettext}</a>
                            {script unique='tweet_src'}
                            {literal}
                                !function(d,s,id){
                                    var js,fjs=d.getElementsByTagName(s)[0];
                                    if(!d.getElementById(id)){
                                        js=d.createElement(s);
                                        js.id=id;
                                        js.src="https://platform.twitter.com/widgets.js";
                                        fjs.parentNode.insertBefore(js,fjs);
                                    }
                                }(document,"script","twitter-wjs");
                            {/literal}
                            {/script}
                        {/if}
                        {if $config.enable_facebook_like || $config.enable_tweet}
                            {br}
                        {/if}
                        {if $config.show_speaker && !empty($sermon->speaker_id)}
                            <strong>{'Speaker'|gettext}:</strong>
                            {$sermon->speakers->title}{br}
                        {/if}
                        {if $config.show_service && !empty($sermon->service_id)}
                            <strong>{'Service'|gettext}:</strong>
                            {$sermon->services->title}{br}
                        {/if}
                        {if $config.show_bible && $sermon->bible != ""}
                            <strong>{'Scripture Reference'|gettext}:</strong>
                            {$sermon->bible}{br}
                        {/if}
                        {if !empty($sermon->summary)}
                            <strong>{'Summary'|gettext}:</strong>{br}
                            {$sermon->summary}
                        {/if}
                        {tags_assigned record=$sermon}
                    {*{/group}*}
                    {if $sermon->expFile.powerpointslides && $sermon->expFile.powerpointslides[0]->is_image}
                        {$slides = $sermon->expFile.powerpointslides}
                        {include 'slideshow.tpl'}
                    {/if}
                    {if $config.show_outline_summary}
                        {$outlinesummary = $sermon->body|summarize:"html":"parahtml"}
                    {else}
                        {$outlinesummary = ''}
                    {/if}
                    {if $config.show_outline & $sermon->body != ""}
                        {toggle unique="outline" title='Outline'|gettext collapsed=$config.show_outline_collapsed summary=$outlinesummary}
                            {$sermon->body}
                        {/toggle}
                    {/if}
                    {if $config.show_comments & $sermon->blogbody != ""}
                        {if $config.show_comments_summary}
                            {$commentssummary = $sermon->blogbody|summarize:"html":"parahtml"}
                        {else}
                            {$commentssummary = ''}
                        {/if}
                        {toggle unique="comments" title=$sermon->blogtitle collapsed=$config.show_comments_collapsed summary=$commentssummary}
                            {$sermon->blogbody}
                        {/toggle}
                    {/if}
                    {if $sermon->expFile.sermonaudio || $sermon->expFile.sermonnotes || ($sermon->expFile.powerpointslides && !$sermon->expFile.powerpointslides[0]->is_image) || $sermon->expFile.fusionstudyguide}
                        {group label="Attachments"|gettext}
                            <dl class="attached">
                                {if $sermon->expFile.sermonaudio}
                                    <dt>{'Sermon Audio'|gettext}</dt>
                                    {foreach from=$sermon->expFile.sermonaudio item=sermonaudio name=sermonaudionfiles}
                                        <dd><a class="downloadfile" href="{link action=downloadfile id=$sermonaudio->id}">{$sermonaudio->filename}</a></dd>
                                    {/foreach}
                                {/if}
                                {if $sermon->expFile.sermonnotes}
                                    <dt>{'Sermon Notes'|gettext}</dt>
                                    {foreach from=$sermon->expFile.sermonnotes item=sermonnotes name=sermonnotesfiles}
                                        <dd><a class="downloadfile" href="{link action=downloadfile id=$sermonnotes->id}">{$sermonnotes->filename}</a></dd>
                                    {/foreach}
                                {/if}
                                {if $sermon->expFile.powerpointslides && !$sermon->expFile.powerpointslides[0]->is_image}
                                    <dt>{'Powerpoint Slides'|gettext}</dt>
                                    {foreach from=$sermon->expFile.powerpointslides item=powerpointslides name=powerpointslidesfiles}
                                        <dd><a class="downloadfile" href="{link action=downloadfile id=$powerpointslides->id}">{$powerpointslides->filename}</a></dd>
                                    {/foreach}
                                {/if}
                                {if $sermon->expFile.fusionstudyguide}
                                    <dt>{'Study Guide'|gettext}</dt>
                                    {foreach from=$sermon->expFile.fusionstudyguide item=fusionstudyguide name=fusionstudyguidefiles}
                                        <dd><a class="downloadfile" href="{link action=downloadfile id=$fusionstudyguide->id}">{$fusionstudyguide->filename}</a></dd>
                                    {/foreach}
                                {/if}
                            </dl>
                        {/group}
                    {/if}
                {/group}
            </div>
        </div>
    </div>

{script unique="mediaelement-run"}
    $('audio,video').mediaelementplayer({
        success: function(player, node) {
            $('#' + node.id + '-mode').html('mode: ' + player.pluginType);
        }
    });
{/script}
