{*
 * Copyright (c) 2004-2014 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

{if !$error}
{uniqueid prepend="sermon" assign="name"}

{css unique="sermon" link="`$asset_path`css/sermons.css" core="common"}

{/css}
{css unique="mediaelement" link="`$smarty.const.PATH_RELATIVE`external/mediaelement/build/mediaelementplayer.css"}

{/css}

<div class="module sermonseries show">
    {if $moduletitle && !($config.hidemoduletitle xor $smarty.const.INVERT_HIDE_TITLE)}<{$config.heading_level|default:'h1'}>{/if}
    {rss_link}{if $config.show_comments}{rss_link type=comments title='Subscribe to Sermon Comments'|gettext}{/if}
    {if $moduletitle && !($config.hidemoduletitle xor $smarty.const.INVERT_HIDE_TITLE)}{$moduletitle}</{$config.heading_level|default:'h1'}>{/if}
    {icon action=showall record=$record text="Show All Sermon Series"|gettext}
    {if $permissions.manage}
        {icon class=import action=import_filedownloads text="Import File Download Items"|gettext}
        {if !$config.disabletags}
            {icon controller=expTag class="manage" action=manage_module model='sermonseries' text="Manage Tags"|gettext}
        {/if}
    {/if}
    {subscribe_link}
    <{$config.item_level|default:'h2'}>{'Series Title'|gettext}: {$record->title}</{$config.item_level|default:'h2'}>
    {permissions}
        <div class="item-actions">
            {if $permissions.edit || ($permissions.create && $record->poster == $user->id)}
                {icon action=edit record=$record title="Edit this Sermon Series"|gettext}
            {/if}
            {if $permissions.delete || ($permissions.create && $record->poster == $user->id)}
                {icon action=delete record=$record title="Delete this Sermon Series"|gettext onclick="return confirm('Are you sure you want to delete this Sermon Series?');"}
            {/if}
        </div>
    {/permissions}
    {$record->body}
    {subscribe_link}
    {permissions}
        <div class="module-actions">
            {if $permissions.create}
                {icon class=add action=edit_sermon rank=1 record=$record title="Add a Sermon to this series"|gettext text="Add a Sermon to this series"|gettext}
            {/if}
            {if ($permissions.manage && $rank == 1)}
                {ddrerank items=$page->records model="sermons" label="Sermons"|gettext}
            {/if}
        </div>
    {/permissions}
    <div id="{$name}item">
        {if count($record->sermons)}
            {include 'sermon.tpl'}
        {else}
            <h4>{'There are no sermons in this series'|gettext}</h4>
        {/if}
    </div>
</div>

{script unique="mediaelement-src" jquery="1" src="`$smarty.const.PATH_RELATIVE`external/mediaelement/build/mediaelement-and-player.min.js"}
{/script}

{if $config.ajax_paging}
{script unique="`$name`itemajax" yui3mods="1"}
{literal}
YUI(EXPONENT.YUI3_CONFIG).use('node','io','node-event-delegate', function(Y) {
    var sermon = Y.one('#{/literal}{$name}{literal}item');
    var cfg = {
    			method: "POST",
    			headers: { 'X-Transaction': 'Load Sermon'},
    			arguments : { 'X-Transaction': 'Load Sermon'}
    		};

    src = '{/literal}{$__loc->src}{literal}';
	var sUrl = EXPONENT.PATH_RELATIVE+"index.php?controller=sermonseries&action=show&view=sermon&ajax_action=1&src=" + src + "&title={/literal}{$record->sef_url}{literal}";

	var handleSuccess = function(ioId, o){
//		Y.log(o.responseText);
		Y.log("The success handler was called.  Id: " + ioId + ".", "info", "sermon nav");

        if(o.responseText){
            sermon.setContent(o.responseText);
            sermon.all('script').each(function(n){
                if(!n.get('src')){
                    eval(n.get('innerHTML'));
                } else {
                    var url = n.get('src');
                    if (url.indexOf("ckeditor")) {
                        Y.Get.script(url);
                    };
                };
            });
            sermon.all('link').each(function(n){
                var url = n.get('href');
                Y.Get.css(url);
            });
        } else {
            sermon.one('.loadingdiv').remove();
        }
	};

	//A function handler to use for failed requests:
	var handleFailure = function(ioId, o){
		Y.log("The failure handler was called.  Id: " + ioId + ".", "info", "sermon nav");
	};

	//Subscribe our handlers to IO's global custom events:
	Y.on('io:success', handleSuccess);
	Y.on('io:failure', handleFailure);

    sermon.delegate('click', function(e){
        e.halt();
        cfg.data = "page="+e.currentTarget.get('rel');
        var request = Y.io(sUrl, cfg);
        sermon.setContent(Y.Node.create('<div class="loadingdiv">{/literal}{"Loading Sermon"|gettext}{literal}</div>'));
    }, 'a.s-pager');
});
{/literal}
{/script}
{/if}
{/if}
