{*
 * Copyright (c) 2004-2014 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

{uniqueid prepend="sermon" assign="name"}

{css unique="sermon" link="`$asset_path`css/sermons.css" core="common"}

{/css}

<div class="module sermonseries showall">
    {if $moduletitle && !($config.hidemoduletitle xor $smarty.const.INVERT_HIDE_TITLE)}<{$config.heading_level|default:'h1'}>{/if}
    {rss_link}{if $config.show_comments}{rss_link type=comments title='Subscribe to Sermon Comments'|gettext}{/if}
    {if $moduletitle && !($config.hidemoduletitle xor $smarty.const.INVERT_HIDE_TITLE)}{$moduletitle}</{$config.heading_level|default:'h1'}>{/if}
    {subscribe_link}
    {permissions}
        <div class="module-actions">
            {if $permissions.create}
                {icon class=add action=edit rank=1 title="Add a Sermon Series at the Top"|gettext text="Add a Sermon Series"|gettext}
            {/if}
            {if $permissions.manage}
                {if $config.show_speaker}
                    {icon class=manage action=manage_speakers text="Manage Speakers"|gettext}
                {/if}
                {if $config.show_service}
                    {icon class=manage action=manage_services text="Manage Services"|gettext}
                {/if}
                {if !empty($page->records)}
                    {icon class=import action=import_filedownloads text="Import File Download Items"|gettext}
                    {*{icon class=import action=import_blogs text="Import Blog Items"|gettext}*}
                    {if $rank == 1}
                        {ddrerank items=$page->records model="sermonseries" label="Sermon Series"|gettext}
                    {/if}
                {/if}
            {/if}
        </div>
    {/permissions}
    <div id="{$name}list">
        {include 'sermonlist.tpl'}
    </div>
</div>

{if $config.ajax_paging}
{script unique="`$name`listajax" yui3mods="1"}
{literal}
YUI(EXPONENT.YUI3_CONFIG).use('node','io','node-event-delegate', function(Y) {
    var sermonlist = Y.one('#{/literal}{$name}{literal}list');
    var cfg = {
    			method: "POST",
    			headers: { 'X-Transaction': 'Load Sermonseriesitems'},
    			arguments : { 'X-Transaction': 'Load Sermonseriesitems'}
    		};

    src = '{/literal}{$__loc->src}{literal}';
	var sUrl = EXPONENT.PATH_RELATIVE+"index.php?controller=sermonseries&action=showall&view=sermonlist&ajax_action=1&src="+src;

	var handleSuccess = function(ioId, o){
//		Y.log(o.responseText);
		Y.log("The success handler was called.  Id: " + ioId + ".", "info", "sermonseriesitems nav");

        if(o.responseText){
                sermonlist.setContent(o.responseText);
                sermonlist.all('script').each(function(n){
                if(!n.get('src')){
                    eval(n.get('innerHTML'));
                } else {
                    var url = n.get('src');
                    if (url.indexOf("ckeditor")) {
                        Y.Get.script(url);
                    };
                };
            });
                sermonlist.all('link').each(function(n){
                var url = n.get('href');
                Y.Get.css(url);
            });
        } else {
            sermonlist.one('.loadingdiv').remove();
        }
	};

	//A function handler to use for failed requests:
	var handleFailure = function(ioId, o){
		Y.log("The failure handler was called.  Id: " + ioId + ".", "info", "sermonseriesitems nav");
	};

	//Subscribe our handlers to IO's global custom events:
	Y.on('io:success', handleSuccess);
	Y.on('io:failure', handleFailure);

    sermonlist.delegate('click', function(e){
        e.halt();
        cfg.data = "page="+e.currentTarget.get('rel');
        var request = Y.io(sUrl, cfg);
        sermonlist.setContent(Y.Node.create('<div class="loadingdiv">{/literal}{"Loading Sermon Series"|gettext}{literal}</div>'));
    }, 'a.pager');
});
{/literal}
{/script}
{/if}
