{*
 * Copyright (c) 2004-2014 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

{css unique="aggregation" corecss="tables"}

{/css}

<h2>{"Import sermons from File Downloads modules"|gettext}</h2>
<blockquote>
    {'Select the items to import.'|gettext}
</blockquote>
{form action="import_filedownloads_process"}
    <table class="exp-skin-table">
        <thead>
            <tr>
                <th><input type='checkbox' name='checkall' title="{'Select All/None'|gettext}" style="margin-left: 1px;" onchange="selectAll(this.checked)"></th>
                {$files->header_columns}
            </tr>
        </thead>
        <tbody>
    {foreach from=$files->records item=fd}
            <tr class="{cycle values="even,odd"}">
                <td width="20">
                    {control type="checkbox" name="file[]" value=$fd->id}
                </td>
                <td>
                    {$fd->title}
                </td>
                <td>
                    {$fd->expCat[0]->title}
                </td>
            </tr>
    {foreachelse}
            <tr><td colspan=3>{'There doesn\'t appear to be any filedownloads that you can import sermons from'|gettext}</td></tr>
    {/foreach}
        </tbody>
    </table>
    {control type="dropdown" name="selectedseries" label="Import to this Sermon Series"|gettext items=$serieslist description='Also used for all uncategorized items'|gettext}
    {control type="checkbox" name="createseries" label="Create sermon series based on categories?"|gettext description='Default process is to import all sermons into the current sermon series'|gettext}
    {if $config.show_bible}
        {control type="checkbox" name="parse_scripture" label="Parse first line as scripture reference?"|gettext value=1 checked=$config.parse_scripture}
    {/if}
    {control type="buttongroup" submit="Import Selected Sermons"|gettext cancel="Cancel"|gettext}
{/form}

{script unique="aggregation"}
    function selectAll(val) {
        var checks = document.getElementsByName("file[]");
        for (var i = 0; i < checks.length; i++) {
          checks[i].checked = val;
        }
    }
{/script}
