{*
 * Copyright (c) 2004-2014 OIC Group, Inc.
 *
 * This file is part of Exponent
 *
 * Exponent is free software; you can redistribute
 * it and/or modify it under the terms of the GNU
 * General Public License as published by the Free
 * Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GPL: http://www.gnu.org/licenses/gpl.txt
 *
 *}

<div class="scaffold showall-by-tags">
	<{$config.heading_level|default:'h1'}>{$moduletitle}</{$config.heading_level|default:'h1'}>
	{permissions}
		<div class="module-actions">
        	{if $permissions.create}
        		{icon controller=$model_name action=add text="Create a new"|gettext|cat:" `$modelname`"}{br}
        	{/if}
		</div>
    {/permissions}
	<ul>
        {foreach from=$items item=listing}
            <li class="listing">
                <h3><a class="readmore" href="{link controller=$controller action=show_sermon title=$listing->sef_url}"  title={'Show this Sermon'|gettext}>{$listing->title}</a></h3>
                <strong>{'Date'|gettext}:</strong> {$listing->date|format_date:"%B %e, %Y"}
                <span class="attribution">
                    - {'from'|gettext} {$listing->sermonseries->title}{br}
                    {if $config.show_speaker && !empty($listing->speaker_id)}
                        <strong>{'Speaker'|gettext}:</strong>
                        {$listing->speakers->title}{br}
                    {/if}
                    {if $config.show_service && !empty($listing->service_id)}
                        <strong>{'Service'|gettext}:</strong>
                        {$listing->services->title}{br}
                    {/if}
                    {if $config.show_bible && $listing->bible != ""}
                        <strong>{'Scripture Reference'|gettext}:</strong>
                        {$listing->bible}{br}
                    {/if}
                    {if !empty($listing->summary)}
                        <strong>{'Summary'|gettext}:</strong>{br}
                        {$listing->summary}
                    {/if}
                </span>
                {permissions}
                    <div class="item-actions">
                        {if $permissions.edit || ($permissions.create && $listing->poster == $user->id)}
                            {icon class=edit controller=$controller action=edit_sermon record=$listing}
                        {/if}
                        {if $permissions.delete || ($permissions.create && $listing->poster == $user->id)}
                            {icon class=delete controller=$controller action=delete_sermon record=$listing}
                        {/if}
                    </div>
                {/permissions}
                <p>
                    {$listing->body|summarize:"html":"parahtml"}
                </p>
                {clear}
            </li>
        {/foreach}
	</ul>
</div>
