<?php
##################################################
#
# Copyright (c) 2004-2018 OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# GPL: http://www.gnu.org/licenses/gpl.txt
#
##################################################

require_once(__DIR__ . '/config/tcpdf.config.php');

spl_autoload_register(function ($class) {
    // Don't interfere with other autoloaders
    if (0 !== strpos($class, 'Spipu\Html2Pdf')) {
        return;
    }

    $class = str_replace('Spipu\Html2Pdf\\', '', $class);
    $path = __DIR__.'/'.str_replace('_', '/', $class).'.php';

    if (!file_exists($path)) {
        return;
    }

    require $path;

});
