/*!
 * MediaElement.js
 * http://www.mediaelementjs.com/
 *
 * Wrapper that mimics native HTML5 MediaElement (audio and video)
 * using a variety of technologies (pure JavaScript, Flash, iframe)
 *
 * Copyright 2010-2017, John Dyer (http://j.hn/)
 * License: MIT
 *
 */
!function r(s,d,u){function a(o,e){if(!d[o]){if(!s[o]){var i="function"==typeof require&&require;if(!e&&i)return i(o,!0);if(c)return c(o,!0);var t=new Error("Cannot find module '"+o+"'");throw t.code="MODULE_NOT_FOUND",t}var n=d[o]={exports:{}};s[o][0].call(n.exports,function(e){return a(s[o][1][e]||e)},n,n.exports,r,s,d,u)}return d[o].exports}for(var c="function"==typeof require&&require,e=0;e<u.length;e++)a(u[e]);return a}({1:[function(e,o,i){"use strict";mejs.i18n.en["mejs.a11y-audio-description"]="Toggle audio description",mejs.i18n.en["mejs.a11y-video-description"]="Toggle sign language",Object.assign(mejs.MepDefaults,{videoDescriptionToggled:!1,audioDescriptionToggled:!1,defaultSource:null,audioDescriptionSource:null,videoDescriptionSource:null,isPlaying:!1,isVoiceover:!1,audioDescriptionCanPlay:!1}),Object.assign(MediaElementPlayer.prototype,{builda11y:function(){var e=this;e.options.defaultSource={src:e.node.src,type:e.node.type},e.options.isVoiceover=e._loadBooleanFromAttribute("data-audio-description-voiceover"),e.options.audioDescriptionSource=e._loadSourceFromAttribute("data-audio-description"),e.options.videoDescriptionSource=e._loadSourceFromAttribute("data-video-description"),e.options.audioDescriptionSource&&e._createAudioDescription(),e.options.videoDescriptionSource&&e._createVideoDescription(),e.node.addEventListener("play",function(){return e.options.isPlaying=!0}),e.node.addEventListener("playing",function(){return e.options.isPlaying=!0}),e.node.addEventListener("pause",function(){return e.options.isPlaying=!1}),e.node.addEventListener("ended",function(){return e.options.isPlaying=!1})},_getFirstChildNodeByClassName:function(e,o){return[].concat(function(e){if(Array.isArray(e)){for(var o=0,i=Array(e.length);o<e.length;o++)i[o]=e[o];return i}return Array.from(e)}(e.childNodes)).find(function(e){return-1<e.className.indexOf(o)})},_createAudioDescription:function(){var e=this,o=mejs.i18n.t("mejs.a11y-audio-description"),i=document.createElement("div");i.className=e.options.classPrefix+"button "+e.options.classPrefix+"audio-description-button",i.innerHTML='<button type="button" aria-controls="'+e.id+'" title="'+o+'" aria-label="'+o+'" tabindex="0"></button>',e.addControlElement(i,"audio-description"),i.addEventListener("click",function(){e.options.audioDescriptionToggled=!e.options.audioDescriptionToggled,mejs.Utils.toggleClass(i,"audio-description-on"),e._toggleAudioDescription()})},_createVideoDescription:function(){var e=this,o=mejs.i18n.t("mejs.a11y-video-description"),i=document.createElement("div");i.className=e.options.classPrefix+"button "+e.options.classPrefix+"video-description-button",i.innerHTML='<button type="button" aria-controls="'+e.id+'" title="'+o+'" aria-label="'+o+'" tabindex="0"></button>',e.addControlElement(i,"video-description"),i.addEventListener("click",function(){e.options.videoDescriptionToggled=!e.options.videoDescriptionToggled,mejs.Utils.toggleClass(i,"video-description-on"),e._toggleVideoDescription()})},_loadSourceFromAttribute:function(o){if(!this.node.hasAttribute(o))return null;var e,i=void 0;try{var t=this.node.getAttribute(o);i=JSON.parse(t)}catch(e){console.error("error loading "+o+": "+e.message)}finally{e=i}return e?this._evaluateBestMatchingSource(e):null},_loadBooleanFromAttribute:function(e){if(!this.node.hasAttribute(e))return!1;var o=this.node.getAttribute(e);return"true"===o||""===o},_evaluateBestMatchingSource:function(e){var t=this,o=function(e){return i=e.type,o=mejs.Utils.getMimeFromType(i),t.node.canPlayType(o);var o,i},i=e.find(function(e){return"probably"===o(e)});if(i)return i;var n=e.find(function(e){return"maybe"===o(e)});return n||null},_createAudioDescriptionPlayer:function(){var i=this,e=document.createElement("audio");if(e.setAttribute("preload","auto"),e.classList.add(i.options.classPrefix+"audio-description-player"),e.setAttribute("src",i.options.audioDescriptionSource.src),e.setAttribute("type",i.options.audioDescriptionSource.type),e.load(),document.body.appendChild(e),i.audioDescription=new mejs.MediaElementPlayer(e,{features:["volume"],audioVolume:i.options.videoVolume,startVolume:i.node.volume,pauseOtherPlayers:!1}),i.audioDescription.node.addEventListener("canplay",function(){return i.options.audioDescriptionCanPlay=!0}),i.node.addEventListener("play",function(){return i.audioDescription.node.play().catch(function(e){return console.error(e)})}),i.node.addEventListener("playing",function(){return i.audioDescription.node.play().catch(function(e){return console.error(e)})}),i.node.addEventListener("pause",function(){return i.audioDescription.node.pause()}),i.node.addEventListener("waiting",function(){return i.audioDescription.node.pause()}),i.node.addEventListener("ended",function(){return i.audioDescription.node.pause()}),i.node.addEventListener("timeupdate",function(){var e=.35<Math.abs(i.node.currentTime-i.audioDescription.node.currentTime),o=i.options.audioDescriptionCanPlay;e&&o&&(i.audioDescription.node.currentTime=i.node.currentTime)}),i.options.isVoiceover)i.node.addEventListener("volumechange",function(){return i.audioDescription.node.volume=i.node.volume});else{var o=i.options.classPrefix+"volume-button",t=i._getFirstChildNodeByClassName(i.controls,o);if(i.videoVolumeButton=t){var n=i._getFirstChildNodeByClassName(i.audioDescription.controls,o);t.classList.add("hidden"),i.controls.insertBefore(n,t.nextSibling),i.descriptiveVolumeButton=n}}},_toggleAudioDescription:function(){var e=this;e.audioDescription||e._createAudioDescriptionPlayer(),e.options.audioDescriptionToggled?(e.audioDescription.node.volume=e.node.volume,e.options.isPlaying&&e.audioDescription&&e.audioDescription.node.play().catch(function(e){return console.error(e)}),e.options.isVoiceover||(e.node.muted=!0,e.audioDescription.node.muted=!1),!e.options.isVoiceover&&e.videoVolumeButton&&e.descriptiveVolumeButton&&(mejs.Utils.addClass(e.videoVolumeButton,"hidden"),mejs.Utils.removeClass(e.descriptiveVolumeButton,"hidden"))):(e.node.volume=e.audioDescription.node.volume,e.audioDescription.node.pause(),e.options.isVoiceover||(e.node.muted=!1,e.audioDescription.node.muted=!0),!e.options.isVoiceover&&e.videoVolumeButton&&e.descriptiveVolumeButton&&(mejs.Utils.removeClass(e.videoVolumeButton,"hidden"),mejs.Utils.addClass(e.descriptiveVolumeButton,"hidden")))},_toggleVideoDescription:function(){var e=this,o=e.node.currentTime,i=e.options.isPlaying,t=e.options.videoDescriptionToggled;e.node.pause(),e.node.src=t?e.options.videoDescriptionSource.src:e.options.defaultSource.src,e.node.type=t?e.options.videoDescriptionSource.type:e.options.defaultSource.type,e.node.load(),i?e.node.play().then(function(){return e.node.currentTime=o}).catch(function(e){return console.error(e)}):e.node.setCurrentTime(o)}})},{}]},{},[1]);