XMLRPC for PHP
==============

Requirements
------------

The following requirements should be met prior to using 'XMLRPC for PHP':

* PHP 5.3.0 or later

* the php "curl" extension is needed if you wish to use SSL or HTTP 1.1 to communicate with remote servers

The php "xmlrpc" native extension is not required, but if it is installed, there will be no interference with the
operation of this library.


Installation instructions
-------------------------

Installation of the library is quite easy:

1.  Via Composer (highly recommended):

    1.  Install composer if you don't have it already present on your system.
        Depending on how you install, you may end up with a composer.phar file in your directory.
        In that case, no worries! Just substitute 'php composer.phar' for 'composer' in the commands below.

    2.  If you're creating a new project, create a new empty directory for it.

    3.  Open a terminal and use Composer to grab the library.

            $ composer require phpxmlrpc/phpxmlrpc:^4.9

    4.  Write your code.
        Once Composer has downloaded the component(s), all you need to do is include the vendor/autoload.php file that
        was generated by Composer. This file takes care of autoloading all of the libraries so that you can use them
        immediately, including phpxmlrpc:

            // File example: src/script.php

            // update this to the path to the "vendor/" directory, relative to this file
            require_once __DIR__.'/../vendor/autoload.php';

            use PhpXmlRpc\Value;
            use PhpXmlRpc\Request;
            use PhpXmlRpc\Client;

            $client = new Client('http://some/server');
            $response = $client->send(new Request('method', array(new Value('parameter'))));

    5.  IMPORTANT! Make sure that the vendor/phpxmlrpc directory is not directly accessible from the internet,
        as leaving it open to access means that any visitor can trigger execution of php code such as
        the built-in debugger.


2.  Via manual download and autoload configuration

    1.  copy the contents of the src/ folder to any location required by your
        application (it can be inside the web server root or not).

    2.  configure your app autoloading mechanism so that all classes in the PhpXmlRpc namespace are loaded
        from that location: any PSR-4 compliant autoloader can do that, if you don't have any there is one
        available in src/Autoloader.php

    3.  Write your code.

            // File example: script.php

            require_once __DIR__.'my_autoloader.php';

            use PhpXmlRpc\Value;
            use PhpXmlRpc\Request;
            use PhpXmlRpc\Client;

            $client = new Client('http://some/server');
            $response = $client->send(new Request('method', array(new Value('parameter'))));

    4.  IMPORTANT! Make sure that the phpxmlrpc directory is not directly accessible from the internet,
        as leaving it open to access means that any visitor can trigger execution of php code such as
        the built-in debugger.

Tips
----

* Please note that usage of the 'pake' command is not required for installation of the library.
  At this moment it is only useful to build the html and pdf versions of the documentation.
